/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import me.pipewasxd.strengthsmp.ConfigManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public record StrengthManager(StrengthSMP plugin, ConfigManager configManager) implements Listener
{
    public int getStrength(Player player) {
        return this.plugin.getConfig().getInt("players." + String.valueOf(player.getUniqueId()) + ".strength", this.configManager.getDefaultStrength());
    }

    public void setStrength(Player player, int strength) {
        int maxStrength = this.configManager.getMaxStrength();
        int minStrength = this.configManager.getMinStrength();
        int oldStrength = this.getStrength(player);
        strength = Math.max(minStrength, Math.min(maxStrength, strength));
        this.plugin.getConfig().set("players." + String.valueOf(player.getUniqueId()) + ".strength", (Object)strength);
        this.plugin.saveConfig();
        this.updatePlayerAttributes(player, strength);
        if (strength >= maxStrength && oldStrength < maxStrength) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
            player.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u029c\u1d00\u1d20\u1d07 \u0280\u1d07\u1d00\u1d04\u029c\u1d07\u1d05 \u1d0d\u1d00x\u026a\u1d0d\u1d1c\u1d0d s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c!");
        }
    }

    public void addStrength(Player player, int amount) {
        int current = this.getStrength(player);
        this.setStrength(player, current + amount);
    }

    public boolean isAtMaxStrength(Player player) {
        return this.getStrength(player) >= this.configManager.getMaxStrength();
    }

    public boolean isAtMinStrength(Player player) {
        return this.getStrength(player) <= this.configManager.getMinStrength();
    }

    private void updatePlayerAttributes(Player player, int strength) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            AttributeInstance instance = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
            if (instance != null) {
                NamespacedKey key = new NamespacedKey("strengthsmp", "strength_modifier");
                instance.getModifiers().stream().filter(mod -> mod.getKey().equals((Object)key)).toList().forEach(arg_0 -> ((AttributeInstance)instance).removeModifier(arg_0));
                if (strength != 0) {
                    AttributeModifier modifier = new AttributeModifier(key, (double)strength, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.HAND);
                    instance.addModifier(modifier);
                }
            }
        });
    }

    public void loadPlayerStrength(Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            int strength = this.getStrength(player);
            this.updatePlayerAttributes(player, strength);
        }, 10L);
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    @NotNull
    public String toString() {
        return "";
    }
}

