/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.pipewasxd.strengthsmp.StrengthManager;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponManager;
import me.pipewasxd.strengthsmp.WeaponType;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class TridentUltimate
implements Listener {
    private final StrengthSMP plugin;
    private final WeaponManager weaponManager;
    private final StrengthManager strengthManager;
    private final Map<UUID, Long> lightningCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> ultimateActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> ultimateCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, BukkitRunnable> cooldownTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, BukkitRunnable> waveTasks = new HashMap<UUID, BukkitRunnable>();

    public TridentUltimate(StrengthSMP plugin, WeaponManager weaponManager, StrengthManager strengthManager) {
        this.plugin = plugin;
        this.weaponManager = weaponManager;
        this.strengthManager = strengthManager;
    }

    public boolean onAbilityCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (player.getInventory().getItemInMainHand().getType() != Material.TRIDENT) {
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#808080:#A9A9A9>\u028f\u1d0f\u1d1c \u1d0d\u1d1cs\u1d1b \u029c\u1d0f\u029f\u1d05 \u1d00 \u1d1b\u0280\u026a\u1d05\u1d07\u0274\u1d1b \u1d1b\u1d0f \u1d1cs\u1d07 \u1d1b\u029c\u026as!</gradient></bold>"));
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.6f, 1.2f);
            return true;
        }
        if (this.weaponManager.getPlayerWeapon(player) != WeaponType.TRIDENT) {
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#808080:#A9A9A9>\u028f\u1d0f\u1d1c \u1d05\u1d0f\u0274'\u1d1b \u029c\u1d00\u1d20\u1d07 \u1d1b\u029c\u1d07 \u1d1b\u0280\u026a\u1d05\u1d07\u0274\u1d1b \u1d21\u1d07\u1d00\u1d18\u1d0f\u0274!</gradient></bold>"));
            return true;
        }
        if (!this.strengthManager.isAtMaxStrength(player)) {
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#808080:#A9A9A9>\u028f\u1d0f\u1d1c \u1d0d\u1d1cs\u1d1b \u0299\u1d07 \u1d00\u1d1b \u1d0d\u1d00x s\u1d1b\u0280\u1d07\u0274\u0262\u1d1b\u029c \u1d1b\u1d0f \u1d1cs\u1d07 \u1d1b\u029c\u026as!</gradient></bold>"));
            return true;
        }
        UUID uuid = player.getUniqueId();
        if (this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return true;
        }
        if (this.isOnCooldown(player)) {
            long remaining = (this.ultimateCooldown.get(uuid) - System.currentTimeMillis()) / 1000L;
            return true;
        }
        this.activateUltimate(player);
        return true;
    }

    @EventHandler
    public void onTridentHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (attacker.getInventory().getItemInMainHand().getType() != Material.TRIDENT) {
            return;
        }
        if (this.weaponManager.getPlayerWeapon(attacker) != WeaponType.TRIDENT) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(attacker)) {
            return;
        }
        UUID attackerUUID = attacker.getUniqueId();
        Long lastStrike = this.lightningCooldown.get(attackerUUID);
        if (lastStrike != null && System.currentTimeMillis() - lastStrike < 2000L) {
            return;
        }
        Location hitLocation = event.getEntity().getLocation();
        hitLocation.getWorld().strikeLightningEffect(hitLocation);
        this.lightningCooldown.put(attackerUUID, System.currentTimeMillis());
    }

    @EventHandler
    public void onSwapHands(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() != Material.TRIDENT) {
            return;
        }
        if (this.weaponManager.getPlayerWeapon(player) != WeaponType.TRIDENT) {
            return;
        }
        if (!this.strengthManager.isAtMaxStrength(player)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        event.setCancelled(true);
        if (this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        if (this.isOnCooldown(player)) {
            return;
        }
        this.activateUltimate(player);
    }

    public void activateUltimate(final Player player) {
        UUID uuid = player.getUniqueId();
        this.ultimateActive.put(uuid, true);
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#8B0000:#B22222>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u1d00\u1d04\u1d1b\u026a\u1d20\u1d00\u1d1b\u1d07\u1d05</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 0.8f);
        final Location startLoc = player.getLocation().add(0.0, 0.5, 0.0);
        final Vector direction = startLoc.getDirection().setY(0).normalize();
        final double waveWidth = 2.0;
        final int waveHeight = 3;
        final int maxMoves = 20;
        BukkitRunnable waveTask = new BukkitRunnable(this){
            int moves = 0;
            final Location currentLoc = startLoc.clone();
            final Set<Block> previousBlocks = new HashSet<Block>();
            final Set<Block> currentBlocks = new HashSet<Block>();
            final /* synthetic */ TridentUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.clearWaterBlocks(this.previousBlocks, player.getWorld());
                this.previousBlocks.clear();
                this.previousBlocks.addAll(this.currentBlocks);
                this.currentBlocks.clear();
                if (this.moves >= maxMoves) {
                    this.this$0.clearWaterBlocks(this.previousBlocks, player.getWorld());
                    this.this$0.deactivateUltimate(player);
                    this.cancel();
                    return;
                }
                this.currentLoc.add(direction);
                Vector perpendicular = new Vector(-direction.getZ(), 0.0, direction.getX());
                for (double w = -waveWidth; w <= waveWidth; w += 0.8) {
                    for (int h = 0; h < waveHeight; ++h) {
                        Block block = this.currentLoc.clone().add(perpendicular.clone().multiply(w)).add(0.0, (double)h, 0.0).getBlock();
                        if (!block.getType().isAir() && block.getType().isSolid()) continue;
                        block.setType(Material.WATER, false);
                        this.currentBlocks.add(block);
                    }
                }
                for (LivingEntity target : player.getWorld().getNearbyLivingEntities(this.currentLoc, waveWidth + 1.5, (double)waveHeight, waveWidth + 1.5)) {
                    if (target.equals((Object)player)) continue;
                    Vector knockback = direction.clone().multiply(1.5);
                    knockback.setY(0.4);
                    target.setVelocity(knockback);
                    player.getWorld().spawnParticle(Particle.SPLASH, target.getLocation(), 10, 0.4, 1.0, 0.4, 0.1);
                    player.getWorld().playSound(target.getLocation(), Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.2f);
                }
                player.setVelocity(direction.clone().multiply(0.8).setY(0.1));
                player.getWorld().playSound(this.currentLoc, Sound.BLOCK_WATER_AMBIENT, 0.8f, 1.2f);
                ++this.moves;
            }
        };
        waveTask.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        this.waveTasks.put(uuid, waveTask);
    }

    private void clearWaterBlocks(Set<Block> blocks, World world) {
        for (Block block : blocks) {
            if (block.getType() != Material.WATER) continue;
            block.setType(Material.AIR);
            world.spawnParticle(Particle.SPLASH, block.getLocation().add(0.5, 0.5, 0.5), 5, 0.3, 0.3, 0.3, 0.01);
        }
    }

    private void deactivateUltimate(final Player player) {
        final UUID uuid = player.getUniqueId();
        if (!this.ultimateActive.getOrDefault(uuid, false).booleanValue()) {
            return;
        }
        BukkitRunnable task = this.waveTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
        this.ultimateActive.put(uuid, false);
        this.ultimateCooldown.put(uuid, System.currentTimeMillis() + 60000L);
        player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#A9A9A9:#D3D3D3>\u1d0f\u0274 \u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274</gradient></bold>"));
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_LAND, 0.5f, 1.0f);
        BukkitRunnable cooldownTask = new BukkitRunnable(this){
            final /* synthetic */ TridentUltimate this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<bold><gradient:#006400:#008000>\u1d1c\u029f\u1d1b\u026a\u1d0d\u1d00\u1d1b\u1d07 \u0280\u1d07\u1d00\u1d05\u028f</gradient></bold>"));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.this$0.cooldownTasks.remove(uuid);
            }
        };
        cooldownTask.runTaskLater((Plugin)this.plugin, 1200L);
        this.cooldownTasks.put(uuid, cooldownTask);
    }

    public boolean isOnCooldown(Player player) {
        Long cooldownEnd = this.ultimateCooldown.get(player.getUniqueId());
        return cooldownEnd != null && System.currentTimeMillis() < cooldownEnd;
    }
}

