/*
 * Decompiled with CFR 0.152.
 */
package me.pipewasxd.strengthsmp;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.pipewasxd.strengthsmp.StrengthSMP;
import me.pipewasxd.strengthsmp.WeaponType;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class WeaponManager {
    private final StrengthSMP plugin;
    private final Map<UUID, Integer> swordCombo = new HashMap<UUID, Integer>();
    private final Map<UUID, Boolean> swordAutoCrit = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> swordPassiveCooldown = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> swordUltimateActive = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> swordUltimateCooldown = new HashMap<UUID, Long>();

    public WeaponManager(StrengthSMP plugin) {
        this.plugin = plugin;
    }

    public WeaponType getPlayerWeapon(Player player) {
        String weaponName = this.plugin.getConfig().getString("weapons." + String.valueOf(player.getUniqueId()));
        WeaponType weapon = WeaponType.fromString(weaponName);
        if (weapon == null) {
            weapon = WeaponType.random();
            this.setPlayerWeapon(player, weapon);
            player.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "\u028f\u1d0f\u1d1c \u029c\u1d00\u1d20\u1d07 \u0299\u1d07\u1d07\u0274 \u1d00ss\u026a\u0262\u0274\u1d07\u1d05 \u1d1b\u029c\u1d07 " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + weapon.getDisplayName() + String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + " \u1d21\u1d07\u1d00\u1d18\u1d0f\u0274!");
        }
        return weapon;
    }

    public void setPlayerWeapon(Player player, WeaponType weapon) {
        this.plugin.getConfig().set("weapons." + String.valueOf(player.getUniqueId()), (Object)weapon.name());
        this.plugin.saveConfig();
    }

    public void incrementSwordCombo(Player player) {
        UUID uuid = player.getUniqueId();
        int combo = this.swordCombo.getOrDefault(uuid, 0) + 1;
        this.swordCombo.put(uuid, combo);
        if (combo >= 5 && !this.swordAutoCrit.getOrDefault(uuid, false).booleanValue()) {
            this.swordAutoCrit.put(uuid, true);
        }
    }

    public void resetSwordCombo(Player player) {
        UUID uuid = player.getUniqueId();
        this.swordCombo.put(uuid, 0);
        if (this.swordAutoCrit.getOrDefault(uuid, false).booleanValue()) {
            this.swordAutoCrit.put(uuid, false);
            this.swordPassiveCooldown.put(uuid, System.currentTimeMillis() + 30000L);
        }
    }

    public boolean hasSwordAutoCrit(Player player) {
        return this.swordAutoCrit.getOrDefault(player.getUniqueId(), false);
    }

    public int getSwordCombo(Player player) {
        return this.swordCombo.getOrDefault(player.getUniqueId(), 0);
    }

    public boolean isSwordPassiveOnCooldown(Player player) {
        Long cooldownEnd = this.swordPassiveCooldown.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return false;
        }
        return System.currentTimeMillis() < cooldownEnd;
    }

    public boolean isSwordUltimateActive(Player player) {
        return this.swordUltimateActive.getOrDefault(player.getUniqueId(), false);
    }

    public void setSwordUltimateActive(Player player, boolean active) {
        this.swordUltimateActive.put(player.getUniqueId(), active);
    }

    public boolean isSwordUltimateOnCooldown(Player player) {
        Long cooldownEnd = this.swordUltimateCooldown.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return false;
        }
        return System.currentTimeMillis() < cooldownEnd;
    }

    public void setSwordUltimateCooldown(Player player) {
        this.swordUltimateCooldown.put(player.getUniqueId(), System.currentTimeMillis() + 60000L);
    }

    public long getSwordUltimateCooldownRemaining(Player player) {
        Long cooldownEnd = this.swordUltimateCooldown.get(player.getUniqueId());
        if (cooldownEnd == null) {
            return 0L;
        }
        return Math.max(0L, (cooldownEnd - System.currentTimeMillis()) / 1000L);
    }
}

