/*
 * Decompiled with CFR 0.152.
 */
package com.github.nutt1101;

import com.github.nutt1101.CatchBall;
import com.github.nutt1101.ConfigSetting;
import com.github.nutt1101.event.HitEvent;
import com.github.nutt1101.utils.NBTHandler;
import com.github.nutt1101.utils.TranslationFileReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class HeadDrop {
    private final Plugin plugin = CatchBall.plugin;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss");

    public ItemStack getEntityHead(Entity hitEntity, Player player) {
        YamlConfiguration entityFile = ConfigSetting.entityFile;
        ItemStack entityHead = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta headMeta = entityHead.getItemMeta();
        String hitEntityUuid = hitEntity.getUniqueId().toString();
        PersistentDataContainer headData = headMeta.getPersistentDataContainer();
        headData.set(new NamespacedKey(this.plugin, "skullData"), PersistentDataType.STRING, (Object)hitEntityUuid);
        Date now = new Date();
        String location = "(" + hitEntity.getWorld().getName() + ") " + HitEvent.getCoordinate(hitEntity.getLocation());
        if (hitEntity.getCustomName() != null) {
            headMeta.setDisplayName(String.valueOf(ChatColor.WHITE) + hitEntity.getCustomName());
        } else {
            headMeta.setDisplayName(String.valueOf(ChatColor.WHITE) + entityFile.getString("EntityList." + hitEntity.getType().toString() + ".DisplayName"));
        }
        ArrayList headLore = new ArrayList();
        if (player == null) {
            headLore.addAll(TranslationFileReader.dropSkullLore.stream().map(lore -> ChatColor.translateAlternateColorCodes((char)'&', (String)lore).replace("{ENTITY}", hitEntity.getType().toString()).replace("{PLAYER}", "Dispenser").replace("{TIME}", this.format.format(now)).replace("{LOCATION}", location)).collect(Collectors.toList()));
        } else {
            headLore.addAll(TranslationFileReader.dropSkullLore.stream().map(lore -> ChatColor.translateAlternateColorCodes((char)'&', (String)lore).replace("{ENTITY}", hitEntity.getType().toString()).replace("{PLAYER}", player.getName()).replace("{TIME}", this.format.format(now)).replace("{LOCATION}", location)).collect(Collectors.toList()));
        }
        headMeta = NBTHandler.saveEntityNBT(this.plugin, hitEntity, headMeta);
        headMeta.setLore(headLore);
        entityHead.setItemMeta(headMeta);
        return this.skullTextures(entityHead, entityFile, hitEntity.getType().toString());
    }

    public ItemStack skullTextures(ItemStack head, YamlConfiguration entityFile, String entityType) {
        SkullMeta skullMeta = (SkullMeta)head.getItemMeta();
        try {
            PlayerProfile profile = Bukkit.createPlayerProfile((String)"catchball");
            PlayerTextures textures = profile.getTextures();
            String textureValue = entityFile.getString("EntityList." + entityType.toUpperCase() + ".Skull");
            if (textureValue != null && !textureValue.isEmpty()) {
                try {
                    String decodedValue = new String(Base64.getDecoder().decode(textureValue));
                    String urlStr = decodedValue.split("\"url\":\"")[1].split("\"")[0];
                    URL textureUrl = new URL(urlStr);
                    textures.setSkin(textureUrl);
                    profile.setTextures(textures);
                    skullMeta.setOwnerProfile(profile);
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to decode texture value: " + e.getMessage());
                }
            } else {
                this.plugin.getLogger().log(Level.WARNING, "Could not find texture value for entity type: " + entityType);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to set skull texture: " + e.getMessage());
            e.printStackTrace();
        }
        head.setItemMeta((ItemMeta)skullMeta);
        return head;
    }
}

