/*
 * Decompiled with CFR 0.152.
 */
package com.github.nutt1101.command;

import com.github.nutt1101.ConfigSetting;
import com.github.nutt1101.command.CommandCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.util.StringUtil;

public class TabComplete
implements TabCompleter {
    List<String> entityList = new ArrayList<String>();

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equals("ctb")) {
            ArrayList<String> sort = new ArrayList<String>();
            if (!sender.hasPermission("catchball.op")) {
                return List.of("");
            }
            if (args.length == 1) {
                StringUtil.copyPartialMatches((String)args[0], CommandCheck.getCommandArgument(), sort);
                return sort;
            }
            if (args.length == 2) {
                this.entityList.clear();
                if (args[0].equalsIgnoreCase("give")) {
                    ArrayList<String> playerNames = new ArrayList<String>();
                    Bukkit.getOnlinePlayers().forEach(player -> playerNames.add(player.getName()));
                    this.searchPlayerNames(args[1], playerNames, sort);
                    sort.sort(String.CASE_INSENSITIVE_ORDER);
                    return sort;
                }
                if (args[0].equalsIgnoreCase("add")) {
                    Set allEntityList = ConfigSetting.entityFile.getConfigurationSection("EntityList").getKeys(false);
                    int availableToAdd = 0;
                    for (String entityName : allEntityList) {
                        EntityType entityType = this.safeGetEntityType(entityName);
                        if (entityType == null || ConfigSetting.catchableEntity.contains(entityType)) continue;
                        this.entityList.add(entityName);
                        ++availableToAdd;
                    }
                    if (availableToAdd > 1) {
                        this.entityList.add("ALL");
                    }
                    StringUtil.copyPartialMatches((String)args[1], this.entityList, sort);
                    return sort;
                }
                if (args[0].equalsIgnoreCase("remove")) {
                    Set allEntityList = ConfigSetting.entityFile.getConfigurationSection("EntityList").getKeys(false);
                    int availableToRemove = 0;
                    for (String entityName : allEntityList) {
                        EntityType entityType = this.safeGetEntityType(entityName);
                        if (entityType == null || !ConfigSetting.catchableEntity.contains(entityType)) continue;
                        this.entityList.add(entityName);
                        ++availableToRemove;
                    }
                    if (availableToRemove > 0) {
                        this.entityList.add("ALL");
                    }
                    StringUtil.copyPartialMatches((String)args[1], this.entityList, sort);
                    return sort;
                }
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("give")) {
                    StringUtil.copyPartialMatches((String)args[2], Arrays.asList("CatchBall", "DropItem"), sort);
                    return sort;
                }
            } else if (args.length == 4 && args[0].equalsIgnoreCase("give")) {
                StringUtil.copyPartialMatches((String)args[3], Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9"), sort);
                return sort;
            }
        }
        return List.of("");
    }

    private void searchPlayerNames(String input, List<String> playerNames, List<String> results) {
        if (input == null || input.isEmpty()) {
            results.addAll(playerNames);
            return;
        }
        String lowerInput = input.toLowerCase();
        for (String playerName : playerNames) {
            if (!playerName.toLowerCase().startsWith(lowerInput)) continue;
            results.add(playerName);
        }
        for (String playerName : playerNames) {
            String lowerPlayerName = playerName.toLowerCase();
            if (!lowerPlayerName.contains(lowerInput) || lowerPlayerName.startsWith(lowerInput)) continue;
            results.add(playerName);
        }
    }

    private EntityType safeGetEntityType(String entityName) {
        try {
            return EntityType.valueOf((String)entityName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

