/*
 * Decompiled with CFR 0.152.
 */
package com.github.nutt1101.Recipe;

import com.github.nutt1101.CatchBall;
import com.github.nutt1101.ConfigSetting;
import com.github.nutt1101.items.Ball;
import com.github.nutt1101.items.DropItem;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class BallRecipe {
    private final Plugin plugin = CatchBall.plugin;

    public BallRecipe() {
        if (ConfigSetting.recipeEnabled) {
            NamespacedKey ballKey = new NamespacedKey(this.plugin, "ballKey");
            ShapedRecipe ballRecipe = new ShapedRecipe(ballKey, Ball.makeBall());
            FileConfiguration config = this.plugin.getConfig();
            Set recipePath = config.getConfigurationSection("Recipe.key").getKeys(false);
            ballRecipe.shape(config.getStringList("Recipe.shape").toArray(new String[3]));
            for (String key : recipePath) {
                String ItemName = config.getString("Recipe.key." + key).toUpperCase();
                if (ItemName instanceof String) {
                    if (ItemName.equals("DROPITEM")) {
                        ballRecipe.setIngredient(key.charAt(0), (RecipeChoice)new RecipeChoice.ExactChoice(DropItem.makeDropItem()));
                        continue;
                    }
                    ballRecipe.setIngredient(key.charAt(0), Material.valueOf((String)ItemName));
                    continue;
                }
                ballRecipe.setIngredient(key.charAt(0), (RecipeChoice)new RecipeChoice.MaterialChoice(config.getStringList("Recipe.key." + key).stream().map(list -> Material.valueOf((String)list)).collect(Collectors.toList())));
            }
            if (Bukkit.getRecipe((NamespacedKey)ballKey) != null) {
                Bukkit.removeRecipe((NamespacedKey)ballKey);
            }
            Bukkit.addRecipe((Recipe)ballRecipe);
        }
    }
}

