/*
 * Decompiled with CFR 0.152.
 */
package com.github.nutt1101.utils;

import org.bukkit.NamespacedKey;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import tw.maoyue.catchball.libs.nbtapi.NBTContainer;
import tw.maoyue.catchball.libs.nbtapi.NBTEntity;

public class NBTHandler {
    public static ItemMeta saveEntityNBT(Plugin plugin, Entity hitEntity, ItemMeta headMeta) {
        NBTEntity nbtEntity = new NBTEntity(hitEntity);
        String nbtData = nbtEntity.toString();
        headMeta.getPersistentDataContainer().set(new NamespacedKey(plugin, "entity"), PersistentDataType.STRING, (Object)nbtData);
        headMeta.getPersistentDataContainer().set(new NamespacedKey(plugin, "entityType"), PersistentDataType.STRING, (Object)hitEntity.getType().toString());
        return headMeta;
    }

    public static void loadEntityNBT(Plugin plugin, Entity entity, PersistentDataContainer data) {
        try {
            String nbtString = (String)data.get(new NamespacedKey(plugin, "entity"), PersistentDataType.STRING);
            if (nbtString != null) {
                NBTContainer nbtContainer = new NBTContainer(nbtString);
                NBTEntity nbtEntity = new NBTEntity(entity);
                nbtEntity.mergeCompound(nbtContainer);
                if (entity instanceof Ageable) {
                    Ageable ageableEntity = (Ageable)entity;
                    if (!nbtContainer.hasTag("IsBaby") || !nbtContainer.getBoolean("IsBaby").booleanValue()) {
                        ageableEntity.setAdult();
                    } else {
                        ageableEntity.setBaby();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String isCustomEntity(Entity hitEntity) {
        NBTEntity nbtEntity = new NBTEntity(hitEntity);
        return nbtEntity.getString("Paper.SpawnReason");
    }
}

