/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells;

import com.mojang.logging.LogUtils;
import com.wintercogs.ae2omnicells.Config;
import com.wintercogs.ae2omnicells.common.init.OCBlocks;
import com.wintercogs.ae2omnicells.common.init.OCCreativeModeTabs;
import com.wintercogs.ae2omnicells.common.init.OCDataComponents;
import com.wintercogs.ae2omnicells.common.init.OCItems;
import com.wintercogs.ae2omnicells.common.init.OCMenus;
import com.wintercogs.ae2omnicells.common.me.AEPlugin;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="ae2omnicells")
public class AE2OmniCells {
    public static final String MODID = "ae2omnicells";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MEGA_MODID = "megacells";
    public static boolean MEGA_LOADED = false;
    public static final String EAE_MODID = "extendedae";
    public static boolean EAE_LOADED = false;

    public AE2OmniCells(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::constructMod);
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        OCDataComponents.register(modEventBus);
        OCItems.register(modEventBus);
        OCBlocks.register(modEventBus);
        OCCreativeModeTabs.register(modEventBus);
        OCMenus.registerMenus(modEventBus);
    }

    private void constructMod(FMLConstructModEvent event) {
        if (ModList.get().isLoaded(MEGA_MODID)) {
            MEGA_LOADED = true;
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AEPlugin.register();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("AE2OmniCells - Server started");
    }

    public static ResourceLocation makeId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @EventBusSubscriber(modid="ae2omnicells", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("AE2OmniCells - Client started");
        }
    }
}

