/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.init;

import appeng.api.stacks.GenericStack;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class OCDataComponents {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"ae2omnicells");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> CELL_BYTES_USAGE = OCDataComponents.register("cell_bytes_usage", b -> b.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT).cacheEncoding());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> CELL_TYPES_USAGE = OCDataComponents.register("cell_types_usage", b -> b.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT).cacheEncoding());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> CELL_STATE = OCDataComponents.register("cell_state", b -> b.persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8).cacheEncoding());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<GenericStack>>> CELL_SHOW_TOOLTIP_STACKS = OCDataComponents.register("cell_show_tooltip_stacks", b -> b.persistent(GenericStack.FAULT_TOLERANT_LIST_CODEC).networkSynchronized(ByteBufCodecs.collection(ArrayList::new, (StreamCodec)GenericStack.STREAM_CODEC)).cacheEncoding());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<UUID>> CELL_UUID = OCDataComponents.register("cell_uuid", b -> b.persistent(UUIDUtil.CODEC).networkSynchronized(UUIDUtil.STREAM_CODEC).cacheEncoding());

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return DATA_COMPONENTS.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    public static void register(IEventBus eventBus) {
        DATA_COMPONENTS.register(eventBus);
    }
}

