---
navigation:
  parent: index.md
  title: Storage Cells
  icon: ae2omnicells:quantum_omni_cell_256m
  position: 20
item_ids:
  - omni_cell_housing
  - complex_omni_cell_housing
  - quantum_omni_cell_housing
  - omni_cell_component_1k
  - omni_cell_component_4k
  - omni_cell_component_16k
  - omni_cell_component_64k
  - omni_cell_component_256k
  - omni_cell_component_1m
  - omni_cell_component_4m
  - omni_cell_component_16m
  - omni_cell_component_64m
  - omni_cell_component_256m
  - complex_omni_cell_component_1k
  - complex_omni_cell_component_4k
  - complex_omni_cell_component_16k
  - complex_omni_cell_component_64k
  - complex_omni_cell_component_256k
  - complex_omni_cell_component_1m
  - complex_omni_cell_component_4m
  - complex_omni_cell_component_16m
  - complex_omni_cell_component_64m
  - complex_omni_cell_component_256m
  - quantum_omni_cell_component_1k
  - quantum_omni_cell_component_4k
  - quantum_omni_cell_component_16k
  - quantum_omni_cell_component_64k
  - quantum_omni_cell_component_256k
  - quantum_omni_cell_component_1m
  - quantum_omni_cell_component_4m
  - quantum_omni_cell_component_16m
  - quantum_omni_cell_component_64m
  - quantum_omni_cell_component_256m
  - omni_cell_1k
  - omni_cell_4k
  - omni_cell_16k
  - omni_cell_64k
  - omni_cell_256k
  - omni_cell_1m
  - omni_cell_4m
  - omni_cell_16m
  - omni_cell_64m
  - omni_cell_256m
  - complex_omni_cell_1k
  - complex_omni_cell_4k
  - complex_omni_cell_16k
  - complex_omni_cell_64k
  - complex_omni_cell_256k
  - complex_omni_cell_1m
  - complex_omni_cell_4m
  - complex_omni_cell_16m
  - complex_omni_cell_64m
  - complex_omni_cell_256m
  - quantum_omni_cell_1k
  - quantum_omni_cell_4k
  - quantum_omni_cell_16k
  - quantum_omni_cell_64k
  - quantum_omni_cell_256k
  - quantum_omni_cell_1m
  - quantum_omni_cell_4m
  - quantum_omni_cell_16m
  - quantum_omni_cell_64m
  - quantum_omni_cell_256m
  - portable_omni_cell_1k
  - portable_omni_cell_4k
  - portable_omni_cell_16k
  - portable_omni_cell_64k
  - portable_omni_cell_256k
  - portable_omni_cell_1m
  - portable_omni_cell_4m
  - portable_omni_cell_16m
  - portable_omni_cell_64m
  - portable_omni_cell_256m
  - portable_complex_omni_cell_1k
  - portable_complex_omni_cell_4k
  - portable_complex_omni_cell_16k
  - portable_complex_omni_cell_64k
  - portable_complex_omni_cell_256k
  - portable_complex_omni_cell_1m
  - portable_complex_omni_cell_4m
  - portable_complex_omni_cell_16m
  - portable_complex_omni_cell_64m
  - portable_complex_omni_cell_256m
  - portable_quantum_omni_cell_1k
  - portable_quantum_omni_cell_4k
  - portable_quantum_omni_cell_16k
  - portable_quantum_omni_cell_64k
  - portable_quantum_omni_cell_256k
  - portable_quantum_omni_cell_1m
  - portable_quantum_omni_cell_4m
  - portable_quantum_omni_cell_16m
  - portable_quantum_omni_cell_64m
  - portable_quantum_omni_cell_256m
---

# Storage Cells

> Store **any AE-supported resource types**—**items, fluids**, and other AE resource keys—**together on a single disk**.

This page covers all three series (including portable variants) with unified capacities: **1k / 4k / 16k / 64k / 256k / 1m / 4m / 16m / 64m / 256m**.  
The only difference between series is the strategy for the **maximum number of distinct types that can be stored simultaneously**.

## Quick Comparison

| Series | Max Distinct Types Stored Simultaneously | Recommended Use Cases |
|---|---:|---|
| **OMNI Storage Cells** | **63** types | Typical networks with a focused set of types |
| **Complex OMNI Storage Cells** | **Scales with capacity (12→6400)** | Networks where type count surges as scale increases |
| **Quantum Storage Cells** | **Unlimited** | Late-game, ultra-large, highly diverse networks |

---

## OMNI Storage Cells
<Row>
  <ItemImage id="omni_cell_1k" scale="3" />
  <ItemImage id="omni_cell_4k" scale="3" />
  <ItemImage id="omni_cell_16k" scale="3" />
  <ItemImage id="omni_cell_64k" scale="3" />
  <ItemImage id="omni_cell_256k" scale="3" />
  <ItemImage id="omni_cell_1m" scale="3" />
  <ItemImage id="omni_cell_4m" scale="3" />
  <ItemImage id="omni_cell_16m" scale="3" />
  <ItemImage id="omni_cell_64m" scale="3" />
  <ItemImage id="omni_cell_256m" scale="3" />
</Row>

- **Type limit: 63**
- Supports mixing all AE resource types (items, fluids, etc.) on the same disk.

---

## Complex OMNI Storage Cells
<Row>
  <ItemImage id="complex_omni_cell_1k" scale="3" />
  <ItemImage id="complex_omni_cell_4k" scale="3" />
  <ItemImage id="complex_omni_cell_16k" scale="3" />
  <ItemImage id="complex_omni_cell_64k" scale="3" />
  <ItemImage id="complex_omni_cell_256k" scale="3" />
  <ItemImage id="complex_omni_cell_1m" scale="3" />
  <ItemImage id="complex_omni_cell_4m" scale="3" />
  <ItemImage id="complex_omni_cell_16m" scale="3" />
  <ItemImage id="complex_omni_cell_64m" scale="3" />
  <ItemImage id="complex_omni_cell_256m" scale="3" />
</Row>

- **Type limit increases with capacity**:  
  | Capacity | 1k | 4k | 16k | 64k | 256k | 1m | 4m | 16m | 64m | 256m |
  |---:|---:|---:|---:|---:|---:|---:|---:|---:|---:|---:|
  | Limit (types) | 12 | 25 | 50 | 100 | 200 | 400 | 800 | 1600 | 3200 | 6400 |

> Recommendation: choose this series when you expect the **number of item/fluid types** to surge sharply as you progress—this line offers better scalability and value.

---

## Quantum Storage Cells
<Row>
  <ItemImage id="quantum_omni_cell_1k" scale="3" />
  <ItemImage id="quantum_omni_cell_4k" scale="3" />
  <ItemImage id="quantum_omni_cell_16k" scale="3" />
  <ItemImage id="quantum_omni_cell_64k" scale="3" />
  <ItemImage id="quantum_omni_cell_256k" scale="3" />
  <ItemImage id="quantum_omni_cell_1m" scale="3" />
  <ItemImage id="quantum_omni_cell_4m" scale="3" />
  <ItemImage id="quantum_omni_cell_16m" scale="3" />
  <ItemImage id="quantum_omni_cell_64m" scale="3" />
  <ItemImage id="quantum_omni_cell_256m" scale="3" />
</Row>

- **Type limit: Unlimited**
- Ideal for an ultimate storage solution where you need to hold **extremely diverse** resource types at once;
- You can place nearly all resource types simultaneously (only constrained by total capacity).

---

## Portable Storage Cells

Every series and capacity above also has a **portable variant**.  
Portable versions behave the same as their series counterparts and suit use cases like traveling or out-of-network access.

---

## Data Persistence

- **Disk data stored independently**: the item itself only carries a small amount of information for client-side tooltip display, so there is **no risk of oversized NBT**.
- **Data location**: saved under `data/ae_universal_cell_data` in the save folder.
