/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.blocks;

import appeng.block.crafting.CraftingMonitorBlock;
import appeng.block.crafting.ICraftingUnitType;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.blockentity.crafting.CraftingMonitorBlockEntity;
import appeng.core.definitions.AEParts;
import appeng.core.localization.PlayerMessages;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.recipes.game.CraftingUnitTransformRecipe;
import appeng.util.InteractionUtil;
import com.wintercogs.ae2omnicells.common.blocks.IOmniCraftingBlock;
import com.wintercogs.ae2omnicells.common.me.crafting.OmniCraftingStorageType;
import com.wintercogs.ae2omnicells.common.me.crafting.OmniCraftingUnitType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class OmniCraftingMonitorBlock
extends CraftingMonitorBlock
implements IOmniCraftingBlock {
    public final OmniCraftingUnitType omniCraftingType;

    public OmniCraftingMonitorBlock(OmniCraftingUnitType type) {
        super((ICraftingUnitType)type);
        this.omniCraftingType = type;
    }

    @Override
    @NotNull
    public OmniCraftingUnitType getOmniCraftingUnitType() {
        return this.omniCraftingType;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        CraftingBlockEntity be;
        Block unitBlock;
        InteractionResult result;
        if (InteractionUtil.isInAlternateUseMode((Player)player) && (result = this.removeUpgrade(level, player, pos, (unitBlock = this.omniCraftingType.family.getUnitBaseBlock()).defaultBlockState())) != InteractionResult.FAIL) {
            return result;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CraftingBlockEntity && (be = (CraftingBlockEntity)blockEntity).isFormed() && be.isActive()) {
            if (!level.isClientSide()) {
                MenuOpener.open((MenuType)CraftingCPUMenu.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)be));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public boolean upgrade(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionResult result;
        boolean isUnitBlock;
        if (heldItem.isEmpty()) {
            return false;
        }
        Block upgradedBlock = heldItem.getItem() == AEParts.STORAGE_MONITOR.get() ? this.omniCraftingType.family.getMonitorBlock() : CraftingUnitTransformRecipe.getUpgradedBlock((Level)level, (ItemStack)heldItem);
        if (upgradedBlock == null) {
            return false;
        }
        if (!(upgradedBlock instanceof IOmniCraftingBlock)) {
            return false;
        }
        IOmniCraftingBlock upgradedOCBlock = (IOmniCraftingBlock)upgradedBlock;
        if (upgradedBlock == state.getBlock()) {
            return false;
        }
        if (upgradedOCBlock.getOmniCraftingUnitType().family != this.omniCraftingType.family) {
            return false;
        }
        if (level.isClientSide()) {
            return true;
        }
        BlockState newState = upgradedBlock.defaultBlockState();
        newState = (BlockState)newState.trySetValue((Property)BlockStateProperties.FACING, (Comparable)hit.getDirection());
        boolean bl = isUnitBlock = this.omniCraftingType.storageType == OmniCraftingStorageType.UNIT;
        InteractionResult interactionResult = isUnitBlock ? (this.transform(level, pos, newState) ? InteractionResult.SUCCESS : InteractionResult.FAIL) : (result = this.removeUpgrade(level, player, pos, newState));
        if (result == InteractionResult.FAIL) {
            return false;
        }
        if (result == InteractionResult.PASS) {
            return true;
        }
        heldItem.consume(1, (LivingEntity)player);
        return true;
    }

    public InteractionResult removeUpgrade(Level level, Player player, BlockPos pos, BlockState newState) {
        if (this.omniCraftingType.storageType == OmniCraftingStorageType.UNIT || level.isClientSide()) {
            return InteractionResult.FAIL;
        }
        ItemStack removedUpgrade = this.omniCraftingType.storageType == OmniCraftingStorageType.MONITOR ? AEParts.STORAGE_MONITOR.stack() : CraftingUnitTransformRecipe.getRemovedUpgrade((Level)level, (Block)this);
        if (removedUpgrade.isEmpty()) {
            return InteractionResult.FAIL;
        }
        CraftingMonitorBlockEntity cb = (CraftingMonitorBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (cb != null && cb.getCluster() != null && cb.getCluster().isBusy()) {
            player.displayClientMessage((Component)PlayerMessages.CraftingCpuBusy.text().withColor(0xFF1F1F), true);
            return InteractionResult.PASS;
        }
        if (!this.transform(level, pos, newState)) {
            return InteractionResult.FAIL;
        }
        player.getInventory().placeItemBackInInventory(removedUpgrade);
        return InteractionResult.SUCCESS;
    }

    private boolean transform(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide() || !level.removeBlock(pos, false) || !level.setBlock(pos, state, 3)) {
            return false;
        }
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.5f, 1.0f);
        return true;
    }
}

