/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.items;

import appeng.api.config.FuzzyMode;
import appeng.api.ids.AEComponents;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.items.contents.CellConfig;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.recipes.game.StorageCellDisassemblyRecipe;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import com.wintercogs.ae2omnicells.common.me.biginteger.IAEBigIntegerCell;
import com.wintercogs.ae2omnicells.common.me.localization.AEUniversalTooltips;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AEBigIntegerCellItem
extends Item
implements IAEBigIntegerCell,
ICellWorkbenchItem {
    private final double idleDrain;

    public AEBigIntegerCellItem(Item.Properties pProperties, double idleDrain) {
        super(pProperties);
        this.idleDrain = idleDrain;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag tooltipFlag) {
        if (Platform.isClient()) {
            BigInteger used = IAEBigIntegerCell.getUsedBytes(stack);
            lines.add(AEUniversalTooltips.bytesUsed(used, -1L));
            long typesUsed = IAEBigIntegerCell.getUsedTypes(stack);
            lines.add(AEUniversalTooltips.typesUsed(typesUsed, -1L));
        }
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        List<GenericStack> show;
        boolean showUpg = AEConfig.instance().isTooltipShowCellUpgrades();
        boolean showCnt = AEConfig.instance().isTooltipShowCellContent();
        List upgrades = Collections.emptyList();
        if (showUpg) {
            ArrayList tmp = new ArrayList();
            this.getUpgrades(stack).forEach(tmp::add);
            upgrades = tmp;
        }
        List content = Collections.emptyList();
        boolean hasMore = false;
        if (showCnt && !(show = IAEBigIntegerCell.getTooltipShowStacks(stack)).isEmpty()) {
            int limit = 5;
            if (show.size() > 5) {
                content = new ArrayList<GenericStack>(show.subList(0, 5));
                hasMore = true;
            } else {
                content = new ArrayList<GenericStack>(show);
            }
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, hasMore, true));
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)2);
    }

    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create((ItemStack)is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return (FuzzyMode)is.getOrDefault(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)FuzzyMode.IGNORE_ALL);
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.set(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)fzMode);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        this.disassembleDrive(player.getItemInHand(hand), level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)player.getItemInHand(hand));
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (!InteractionUtil.isInAlternateUseMode((Player)player)) {
            return false;
        }
        List disassembledStacks = StorageCellDisassemblyRecipe.getDisassemblyResult((Level)level, (Item)stack.getItem());
        if (disassembledStacks.isEmpty()) {
            return false;
        }
        Inventory playerInventory = player.getInventory();
        if (playerInventory.getSelected() != stack) {
            return false;
        }
        StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
        if (inv != null && !inv.getAvailableStacks().isEmpty()) {
            player.displayClientMessage((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            return false;
        }
        playerInventory.setItem(playerInventory.selected, ItemStack.EMPTY);
        for (ItemStack disassembledStack : disassembledStacks) {
            playerInventory.placeItemBackInInventory(disassembledStack.copy());
        }
        this.getUpgrades(stack).forEach(arg_0 -> ((Inventory)playerInventory).placeItemBackInInventory(arg_0));
        return true;
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, UseOnContext context) {
        return this.disassembleDrive(stack, context.getLevel(), context.getPlayer()) ? InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide()) : InteractionResult.PASS;
    }
}

