/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.me;

import appeng.api.stacks.AEKey;
import com.wintercogs.ae2omnicells.common.init.OCDataComponents;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AEUniversalCellData
extends SavedData {
    public static final String INV_SAVED_TAG = "inventory";
    private static final String ENTRIES_TAG = "entries";
    private static final String ERROR_ENTRIES_TAG = "error_entries";
    private static final String ENTRY_KEY_TAG = "key";
    private static final String ENTRY_AMOUNT_TAG = "amount";
    private static final String SAVED_FOLDER_NAME = "ae_universal_cell_data";
    private final Object2LongOpenHashMap<AEKey> storage;
    private final ObjectArrayList<CompoundTag> pendingReadErrors;
    public static final SavedData.Factory<AEUniversalCellData> FACTORY = new SavedData.Factory(() -> {
        Object2LongOpenHashMap s = new Object2LongOpenHashMap();
        s.defaultReturnValue(0L);
        return new AEUniversalCellData((Object2LongOpenHashMap<AEKey>)s, (ObjectArrayList<CompoundTag>)new ObjectArrayList());
    }, AEUniversalCellData::load);

    public AEUniversalCellData(@NotNull Object2LongOpenHashMap<AEKey> storage) {
        this(storage, (ObjectArrayList<CompoundTag>)new ObjectArrayList());
    }

    private AEUniversalCellData(@NotNull Object2LongOpenHashMap<AEKey> storage, @NotNull ObjectArrayList<CompoundTag> pendingReadErrors) {
        this.storage = storage;
        this.storage.defaultReturnValue(0L);
        this.pendingReadErrors = pendingReadErrors;
    }

    @NotNull
    public Object2LongMap<AEKey> getOriginalStorage() {
        return this.storage;
    }

    @Nullable
    public static AEUniversalCellData getCellDataByUUID(@NotNull UUID uuid) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        AEUniversalCellData.ensureSaveDirExists(server);
        String key = AEUniversalCellData.makeKey(uuid);
        return (AEUniversalCellData)server.overworld().getDataStorage().get(FACTORY, key);
    }

    @Nullable
    public static AEUniversalCellData computeIfAbsentCellDataForItemStack(@NotNull ItemStack itemStack) {
        UUID fresh;
        AEUniversalCellData data;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        AEUniversalCellData.ensureSaveDirExists(server);
        DimensionDataStorage dataStorage = server.overworld().getDataStorage();
        UUID existing = (UUID)itemStack.get((DataComponentType)OCDataComponents.CELL_UUID.get());
        if (existing != null && (data = AEUniversalCellData.getCellDataByUUID(existing)) != null) {
            return data;
        }
        while (AEUniversalCellData.getCellDataByUUID(fresh = UUID.randomUUID()) != null) {
        }
        itemStack.set((DataComponentType)OCDataComponents.CELL_UUID.get(), (Object)fresh);
        Object2LongOpenHashMap s = new Object2LongOpenHashMap();
        s.defaultReturnValue(0L);
        AEUniversalCellData newData = new AEUniversalCellData((Object2LongOpenHashMap<AEKey>)s);
        dataStorage.set(AEUniversalCellData.makeKey(fresh), (SavedData)newData);
        return newData;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag invTag = new CompoundTag();
        ListTag entriesList = new ListTag();
        for (Object2LongMap.Entry e : this.storage.object2LongEntrySet()) {
            AEKey key = (AEKey)e.getKey();
            long amount = e.getLongValue();
            if (key == null) {
                System.err.println("[AEUniversalCellData] Skip null key during serialization.");
                continue;
            }
            try {
                CompoundTag entry = new CompoundTag();
                entry.put(ENTRY_KEY_TAG, (Tag)key.toTagGeneric(registries));
                entry.putLong(ENTRY_AMOUNT_TAG, amount);
                entriesList.add((Object)entry);
            }
            catch (Throwable ex) {
                System.err.println("[AEUniversalCellData] Failed to serialize entry: key=" + String.valueOf(key) + ", amount=" + amount + " ; cause=" + String.valueOf(ex));
            }
        }
        invTag.put(ENTRIES_TAG, (Tag)entriesList);
        ListTag errorList = new ListTag();
        for (CompoundTag bad : this.pendingReadErrors) {
            errorList.add((Object)bad.copy());
        }
        invTag.put(ERROR_ENTRIES_TAG, (Tag)errorList);
        tag.put(INV_SAVED_TAG, (Tag)invTag);
        return tag;
    }

    public static AEUniversalCellData load(CompoundTag tag, HolderLookup.Provider registries) {
        Object2LongOpenHashMap storage = new Object2LongOpenHashMap();
        storage.defaultReturnValue(0L);
        ObjectArrayList errorQueue = new ObjectArrayList();
        CompoundTag invTag = tag.getCompound(INV_SAVED_TAG);
        ListTag entries = invTag.getList(ENTRIES_TAG, 10);
        for (int i = 0; i < entries.size(); ++i) {
            CompoundTag entry = entries.getCompound(i);
            try {
                CompoundTag keyTag = entry.getCompound(ENTRY_KEY_TAG);
                AEKey key = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)keyTag);
                if (key == null) {
                    errorQueue.add((Object)entry.copy());
                    System.err.println("[AEUniversalCellData] Failed to deserialize entry (null key). Entry=" + String.valueOf(entry));
                    continue;
                }
                long amount = entry.getLong(ENTRY_AMOUNT_TAG);
                storage.addTo((Object)key, amount);
                continue;
            }
            catch (Throwable ex) {
                errorQueue.add((Object)entry.copy());
                System.err.println("[AEUniversalCellData] Failed to deserialize entry: " + String.valueOf(entry) + " ; cause=" + String.valueOf(ex));
            }
        }
        ListTag oldErrors = invTag.getList(ERROR_ENTRIES_TAG, 10);
        for (int i = 0; i < oldErrors.size(); ++i) {
            CompoundTag badEntry = oldErrors.getCompound(i);
            boolean recovered = false;
            try {
                CompoundTag keyTag = badEntry.getCompound(ENTRY_KEY_TAG);
                AEKey key = AEKey.fromTagGeneric((HolderLookup.Provider)registries, (CompoundTag)keyTag);
                if (key != null) {
                    long amount = badEntry.getLong(ENTRY_AMOUNT_TAG);
                    storage.addTo((Object)key, amount);
                    recovered = true;
                }
            }
            catch (Throwable ignored) {
                recovered = false;
            }
            if (recovered) {
                System.err.println("[AEUniversalCellData] Recovered previously failed entry: " + String.valueOf(badEntry));
                continue;
            }
            errorQueue.add((Object)badEntry.copy());
        }
        return new AEUniversalCellData((Object2LongOpenHashMap<AEKey>)storage, (ObjectArrayList<CompoundTag>)errorQueue);
    }

    private static String makeKey(@NotNull UUID uuid) {
        return "ae_universal_cell_data/" + String.valueOf(uuid);
    }

    private static void ensureSaveDirExists(@NotNull MinecraftServer server) {
        Path dir = server.getWorldPath(LevelResource.ROOT).resolve("data").resolve(SAVED_FOLDER_NAME);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("[AEUniversalCellData] Failed to create save directory: " + String.valueOf(dir) + " : " + String.valueOf(e));
        }
    }
}

