---
navigation:
   parent: index.md
   title: Inscriber Presses
   icon: ae2omnicells:multidimensional_expansion_processor
   position: 20
item_ids:
   - ender_ingot
   - charged_ender_ingot
   - omni_link_print_press
   - complex_link_print_press
   - multidimensional_expansion_print_press
   - omni_link_circuit_print
   - complex_link_circuit_print
   - multidimensional_expansion_circuit_print
   - omni_link_processor
   - complex_link_processor
   - multidimensional_expansion_processor
---

# Inscriber Presses

> This page introduces the full chain required to craft the new storage cells: **Presses → Circuit Prints → Processors**.

## Overview

To build the three storage-cell series in this mod (OMNI / Complex OMNI / Quantum), first complete a concise processing pipeline:

1. **Base Materials**: craft **Ender Steel**, and optionally **charge** it further.
2. **Presses**: use Ender materials to make the three series-specific **presses**.
3. **Circuit Prints**: use the AE2 **Inscriber** (压印器) with those presses to produce the corresponding **circuit prints**.
4. **Processors**: assemble the circuit prints with other materials into the three series of **processors**, used by the storage-cell recipes.

---

## Item Overview

### Presses
<Row>
  <ItemImage id="omni_link_print_press" scale="3" />
  <ItemImage id="complex_link_print_press" scale="3" />
  <ItemImage id="multidimensional_expansion_print_press" scale="3" />
</Row>

- **Omni Link Press**
- **Complex Link Press**
- **Multidimensional Expansion Press**

---

### Circuit Prints
<Row>
  <ItemImage id="omni_link_circuit_print" scale="3" />
  <ItemImage id="complex_link_circuit_print" scale="3" />
  <ItemImage id="multidimensional_expansion_circuit_print" scale="3" />
</Row>

- **Omni Link Circuit Print**
- **Complex Link Circuit Print**
- **Multidimensional Expansion Circuit Print**

---

### Processors
<Row>
  <ItemImage id="omni_link_processor" scale="3" />
  <ItemImage id="complex_link_processor" scale="3" />
  <ItemImage id="multidimensional_expansion_processor" scale="3" />
</Row>

- **Omni Link Processor**
- **Complex Link Processor**
- **Multidimensional Expansion Processor**

---

## Crafting Flow

1. **Ender Steel & Charged Ender Steel**
   - Key materials for later presses and high-tier parts.
   - Recipes: see “Recipe Quick Index” below.

2. **Presses**
   - Use Ender materials to craft the three series of presses.
   - Each press is used to inscribe the corresponding series’ circuit prints.

3. **Inscribe Circuit Prints**
   - In the **Inscriber (压印器)**: insert Press + base material → the corresponding **circuit print**.

4. **Assemble Processors**
   - Combine circuit prints with other components to craft the three series of **processors**, used in storage-cell recipes.

> Tip: Exact materials/substitutions and details are subject to JEI/REI/EMI.

---

## Recipe Quick Index

### Base Materials
<RecipeFor id="ender_ingot" />
<RecipeFor id="charged_ender_ingot" />

### Presses
<RecipeFor id="omni_link_print_press" />
<RecipeFor id="complex_link_print_press" />
<RecipeFor id="multidimensional_expansion_print_press" />

### Circuit Prints
<RecipeFor id="omni_link_circuit_print" />
<RecipeFor id="complex_link_circuit_print" />
<RecipeFor id="multidimensional_expansion_circuit_print" />

### Processors
<RecipeFor id="omni_link_processor" />
<RecipeFor id="complex_link_processor" />
<RecipeFor id="multidimensional_expansion_processor" />
