/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.me.biginteger;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.IPartitionList;
import com.wintercogs.ae2omnicells.common.me.biginteger.AEBigIntegerCellData;
import com.wintercogs.ae2omnicells.common.me.biginteger.IAEBigIntegerCell;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.math.BigInteger;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AEBigIntegerCellInventory
implements StorageCell {
    @NotNull
    private final AEBigIntegerCellData cellData;
    @NotNull
    private final Object2ObjectMap<AEKey, BigInteger> storage;
    @NotNull
    private final ItemStack itemStack;
    @NotNull
    private final IAEBigIntegerCell cellType;
    @Nullable
    private final ISaveProvider saveContainer;
    private BigInteger usedBytesCached;
    private boolean isPersisted = false;
    private final Long2ObjectOpenHashMap<BigInteger> bucketSums = new Long2ObjectOpenHashMap();

    public AEBigIntegerCellInventory(@NotNull AEBigIntegerCellData cellData, @NotNull ItemStack itemStack, @NotNull IAEBigIntegerCell cellType, @Nullable ISaveProvider saveProvider) {
        long apb;
        this.cellData = cellData;
        this.storage = cellData.getOriginalStorage();
        this.itemStack = itemStack;
        this.cellType = cellType;
        this.saveContainer = saveProvider;
        this.bucketSums.defaultReturnValue((Object)BigInteger.ZERO);
        for (Object2ObjectMap.Entry e : this.storage.object2ObjectEntrySet()) {
            BigInteger v = AEBigIntegerCellInventory.nonNegative((BigInteger)e.getValue());
            if (v.signum() <= 0) continue;
            apb = Math.max(1, ((AEKey)e.getKey()).getType().getAmountPerByte());
            this.bucketSums.put(apb, (Object)((BigInteger)this.bucketSums.get(apb)).add(v));
        }
        BigInteger bytesForValues = BigInteger.ZERO;
        for (Long2ObjectMap.Entry b : this.bucketSums.long2ObjectEntrySet()) {
            apb = b.getLongKey();
            BigInteger sum = (BigInteger)b.getValue();
            bytesForValues = bytesForValues.add(AEBigIntegerCellInventory.ceilDiv(sum, apb));
        }
        this.usedBytesCached = bytesForValues;
        this.updateItemTooltipState();
    }

    public CellState getStatus() {
        if (this.storage.isEmpty()) {
            return CellState.EMPTY;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public boolean canFitInsideCell() {
        return true;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        this.updateItemTooltipState();
        this.isPersisted = true;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount <= 0L) {
            return 0L;
        }
        if (!this.matchesPartitionAndUpgrades(what)) {
            return 0L;
        }
        if (!this.canNestStorageCells(what)) {
            return 0L;
        }
        long apb = Math.max(1, what.getType().getAmountPerByte());
        BigInteger current = AEBigIntegerCellInventory.nonNegative((BigInteger)this.storage.get((Object)what));
        if (mode == Actionable.MODULATE) {
            BigInteger oldBucket = (BigInteger)this.bucketSums.get(apb);
            BigInteger newBucket = oldBucket.add(BigInteger.valueOf(amount));
            BigInteger deltaValueBytes = AEBigIntegerCellInventory.ceilDiv(newBucket, apb).subtract(AEBigIntegerCellInventory.ceilDiv(oldBucket, apb));
            this.usedBytesCached = this.usedBytesCached.add(deltaValueBytes);
            this.bucketSums.put(apb, (Object)newBucket);
            this.storage.put((Object)what, (Object)current.add(BigInteger.valueOf(amount)));
            this.markChanged();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount <= 0L) {
            return 0L;
        }
        BigInteger current = AEBigIntegerCellInventory.nonNegative((BigInteger)this.storage.get((Object)what));
        if (current.signum() <= 0) {
            return 0L;
        }
        long currentAsLongCap = AEBigIntegerCellInventory.clampToLong(current);
        long taken = Math.min(amount, currentAsLongCap);
        if (taken <= 0L) {
            return 0L;
        }
        if (mode == Actionable.MODULATE) {
            long apb = Math.max(1, what.getType().getAmountPerByte());
            BigInteger oldBucket = (BigInteger)this.bucketSums.get(apb);
            BigInteger newBucket = oldBucket.subtract(BigInteger.valueOf(taken));
            if (newBucket.signum() < 0) {
                newBucket = BigInteger.ZERO;
            }
            BigInteger deltaValueBytes = AEBigIntegerCellInventory.ceilDiv(newBucket, apb).subtract(AEBigIntegerCellInventory.ceilDiv(oldBucket, apb));
            this.usedBytesCached = this.usedBytesCached.add(deltaValueBytes);
            BigInteger next = current.subtract(BigInteger.valueOf(taken));
            if (next.signum() > 0) {
                this.storage.put((Object)what, (Object)next);
            } else {
                this.storage.remove((Object)what);
            }
            if (newBucket.signum() > 0) {
                this.bucketSums.put(apb, (Object)newBucket);
            } else {
                this.bucketSums.remove(apb);
            }
            this.markChanged();
        }
        return taken;
    }

    public void getAvailableStacks(KeyCounter out) {
        for (Object2ObjectMap.Entry entry : this.storage.object2ObjectEntrySet()) {
            long existing;
            long headroom;
            BigInteger value = AEBigIntegerCellInventory.nonNegative((BigInteger)entry.getValue());
            if (value.signum() <= 0 || (headroom = (existing = out.get((AEKey)entry.getKey())) <= 0L ? Long.MAX_VALUE : Long.MAX_VALUE - existing) <= 0L) continue;
            long add = AEBigIntegerCellInventory.clampToLong(value);
            if (add > headroom) {
                add = headroom;
            }
            if (add <= 0L) continue;
            out.add((AEKey)entry.getKey(), add);
        }
    }

    public Component getDescription() {
        return this.itemStack.getHoverName();
    }

    private boolean canNestStorageCells(AEKey what) {
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            ItemStack s = itemKey.toStack();
            StorageCell nested = StorageCells.getCellInventory((ItemStack)s, null);
            return nested == null || nested.canFitInsideCell();
        }
        return true;
    }

    private boolean matchesPartitionAndUpgrades(AEKey what) {
        IUpgradeInventory upgrades = this.cellType.getUpgrades(this.itemStack);
        boolean hasInverter = upgrades.isInstalled((ItemLike)AEItems.INVERTER_CARD);
        boolean hasFuzzy = upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD);
        ConfigInventory config = null;
        FuzzyMode fuzzyMode = FuzzyMode.IGNORE_ALL;
        IAEBigIntegerCell iAEBigIntegerCell = this.cellType;
        if (iAEBigIntegerCell instanceof ICellWorkbenchItem) {
            ICellWorkbenchItem cellWorkbenchItem = (ICellWorkbenchItem)iAEBigIntegerCell;
            config = cellWorkbenchItem.getConfigInventory(this.itemStack);
            if (hasFuzzy) {
                fuzzyMode = cellWorkbenchItem.getFuzzyMode(this.itemStack);
            }
        }
        if (config == null || config.keySet().isEmpty()) {
            return true;
        }
        IPartitionList.Builder builder = IPartitionList.builder();
        if (hasFuzzy) {
            builder.fuzzyMode(fuzzyMode);
        }
        builder.addAll((Iterable)config.keySet());
        IPartitionList list = builder.build();
        IncludeExclude mode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        return list.matchesFilter(what, mode);
    }

    private void markChanged() {
        this.cellData.setDirty();
        this.isPersisted = false;
        if (this.saveContainer != null) {
            this.saveContainer.saveChanges();
        } else {
            this.persist();
        }
    }

    private void updateItemTooltipState() {
        BigInteger used = this.usedBytesCached.signum() > 0 ? this.usedBytesCached : BigInteger.ZERO;
        IAEBigIntegerCell.setUsedBytes(this.itemStack, used);
        IAEBigIntegerCell.setUsedTypes(this.itemStack, this.storage.size());
        IAEBigIntegerCell.setCellState(this.itemStack, this.getStatus());
        ArrayList<GenericStack> show = new ArrayList<GenericStack>(5);
        int count = 0;
        for (Object2ObjectMap.Entry e : this.storage.object2ObjectEntrySet()) {
            BigInteger v = AEBigIntegerCellInventory.nonNegative((BigInteger)e.getValue());
            if (v.signum() <= 0) continue;
            show.add(new GenericStack((AEKey)e.getKey(), AEBigIntegerCellInventory.clampToLong(v)));
            if (++count < 5) continue;
            break;
        }
        IAEBigIntegerCell.setTooltipShowStacks(this.itemStack, show);
    }

    private static BigInteger ceilDiv(BigInteger a, long bLong) {
        if (bLong <= 0L) {
            throw new IllegalArgumentException("div by non-positive");
        }
        if (a.signum() <= 0) {
            return BigInteger.ZERO;
        }
        BigInteger b = BigInteger.valueOf(bLong);
        return a.add(b.subtract(BigInteger.ONE)).divide(b);
    }

    private static BigInteger ceilDiv(BigInteger a, BigInteger b) {
        if (b.signum() <= 0) {
            throw new IllegalArgumentException("div by non-positive");
        }
        if (a.signum() <= 0) {
            return BigInteger.ZERO;
        }
        return a.add(b.subtract(BigInteger.ONE)).divide(b);
    }

    private static long clampToLong(BigInteger v) {
        if (v.signum() <= 0) {
            return 0L;
        }
        if (v.bitLength() > 63) {
            return Long.MAX_VALUE;
        }
        long r = v.longValue();
        return r < 0L ? Long.MAX_VALUE : r;
    }

    private static BigInteger nonNegative(BigInteger v) {
        if (v == null || v.signum() <= 0) {
            return BigInteger.ZERO;
        }
        return v;
    }

    private static BigInteger minBI(BigInteger a, BigInteger b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    private static BigInteger maxBI(BigInteger a, BigInteger b) {
        return a.compareTo(b) >= 0 ? a : b;
    }
}

