/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells;

import com.wintercogs.ae2omnicells.common.config.MekRadialChemicalCheck;
import com.wintercogs.ae2omnicells.common.config.MekRadialChemicalCheckConfig;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    public final StartUpConfig startUpConfig = new StartUpConfig();
    public final CommonConfig commonConfig = new CommonConfig();
    public static Config INSTANCE;

    private Config(ModContainer container) {
        container.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)this.startUpConfig.spec);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.commonConfig.spec);
        container.getEventBus().addListener(evt -> {
            if (evt.getConfig().getSpec() == this.commonConfig.spec) {
                this.commonConfig.onLoaded();
            }
        });
        container.getEventBus().addListener(evt -> {
            if (evt.getConfig().getSpec() == this.commonConfig.spec) {
                this.commonConfig.onLoaded();
            }
        });
    }

    public static void register(ModContainer container) {
        INSTANCE = new Config(container);
    }

    public static class StartUpConfig {
        public final ModConfigSpec spec;
        public final ModConfigSpec.IntValue omniCoProcessor_1k;
        public final ModConfigSpec.IntValue omniCoProcessor_4k;
        public final ModConfigSpec.IntValue omniCoProcessor_16k;
        public final ModConfigSpec.IntValue omniCoProcessor_64k;
        public final ModConfigSpec.IntValue omniCoProcessor_256k;
        public final ModConfigSpec.IntValue omniCoProcessor_1m;
        public final ModConfigSpec.IntValue omniCoProcessor_4m;
        public final ModConfigSpec.IntValue omniCoProcessor_16m;
        public final ModConfigSpec.IntValue omniCoProcessor_64m;
        public final ModConfigSpec.IntValue omniCoProcessor_256m;
        public final ModConfigSpec.IntValue complexCoProcessor_1k;
        public final ModConfigSpec.IntValue complexCoProcessor_4k;
        public final ModConfigSpec.IntValue complexCoProcessor_16k;
        public final ModConfigSpec.IntValue complexCoProcessor_64k;
        public final ModConfigSpec.IntValue complexCoProcessor_256k;
        public final ModConfigSpec.IntValue complexCoProcessor_1m;
        public final ModConfigSpec.IntValue complexCoProcessor_4m;
        public final ModConfigSpec.IntValue complexCoProcessor_16m;
        public final ModConfigSpec.IntValue complexCoProcessor_64m;
        public final ModConfigSpec.IntValue complexCoProcessor_256m;
        public final ModConfigSpec.IntValue quantumCoProcessor_1k;
        public final ModConfigSpec.IntValue quantumCoProcessor_4k;
        public final ModConfigSpec.IntValue quantumCoProcessor_16k;
        public final ModConfigSpec.IntValue quantumCoProcessor_64k;
        public final ModConfigSpec.IntValue quantumCoProcessor_256k;
        public final ModConfigSpec.IntValue quantumCoProcessor_1m;
        public final ModConfigSpec.IntValue quantumCoProcessor_4m;
        public final ModConfigSpec.IntValue quantumCoProcessor_16m;
        public final ModConfigSpec.IntValue quantumCoProcessor_64m;
        public final ModConfigSpec.IntValue quantumCoProcessor_256m;

        public StartUpConfig() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            builder.push("CPU Processors Config (Must restart your game after changed)");
            this.omniCoProcessor_1k = builder.defineInRange("omni_coprocessor_1k", 4, 0, 81920);
            this.omniCoProcessor_4k = builder.defineInRange("omni_coprocessor_4k", 4, 0, 81920);
            this.omniCoProcessor_16k = builder.defineInRange("omni_coprocessor_16k", 4, 0, 81920);
            this.omniCoProcessor_64k = builder.defineInRange("omni_coprocessor_64k", 4, 0, 81920);
            this.omniCoProcessor_256k = builder.defineInRange("omni_coprocessor_256k", 4, 0, 81920);
            this.omniCoProcessor_1m = builder.defineInRange("omni_coprocessor_1m", 8, 0, 81920);
            this.omniCoProcessor_4m = builder.defineInRange("omni_coprocessor_4m", 8, 0, 81920);
            this.omniCoProcessor_16m = builder.defineInRange("omni_coprocessor_16m", 8, 0, 81920);
            this.omniCoProcessor_64m = builder.defineInRange("omni_coprocessor_64m", 8, 0, 81920);
            this.omniCoProcessor_256m = builder.defineInRange("omni_coprocessor_256m", 8, 0, 81920);
            this.complexCoProcessor_1k = builder.defineInRange("complex_coprocessor_1k", 0, 0, 81920);
            this.complexCoProcessor_4k = builder.defineInRange("complex_coprocessor_4k", 1, 0, 81920);
            this.complexCoProcessor_16k = builder.defineInRange("complex_coprocessor_16k", 2, 0, 81920);
            this.complexCoProcessor_64k = builder.defineInRange("complex_coprocessor_64k", 4, 0, 81920);
            this.complexCoProcessor_256k = builder.defineInRange("complex_coprocessor_256k", 8, 0, 81920);
            this.complexCoProcessor_1m = builder.defineInRange("complex_coprocessor_1m", 16, 0, 81920);
            this.complexCoProcessor_4m = builder.defineInRange("complex_coprocessor_4m", 32, 0, 81920);
            this.complexCoProcessor_16m = builder.defineInRange("complex_coprocessor_16m", 64, 0, 81920);
            this.complexCoProcessor_64m = builder.defineInRange("complex_coprocessor_64m", 128, 0, 81920);
            this.complexCoProcessor_256m = builder.defineInRange("complex_coprocessor_256m", 256, 0, 81920);
            this.quantumCoProcessor_1k = builder.defineInRange("quantum_coprocessor_1k", 512, 0, 81920);
            this.quantumCoProcessor_4k = builder.defineInRange("quantum_coprocessor_4k", 512, 0, 81920);
            this.quantumCoProcessor_16k = builder.defineInRange("quantum_coprocessor_16k", 1024, 0, 81920);
            this.quantumCoProcessor_64k = builder.defineInRange("quantum_coprocessor_64k", 1024, 0, 81920);
            this.quantumCoProcessor_256k = builder.defineInRange("quantum_coprocessor_256k", 2048, 0, 81920);
            this.quantumCoProcessor_1m = builder.defineInRange("quantum_coprocessor_1m", 2048, 0, 81920);
            this.quantumCoProcessor_4m = builder.defineInRange("quantum_coprocessor_4m", 4096, 0, 81920);
            this.quantumCoProcessor_16m = builder.defineInRange("quantum_coprocessor_16m", 4096, 0, 81920);
            this.quantumCoProcessor_64m = builder.defineInRange("quantum_coprocessor_64m", 8192, 0, 81920);
            this.quantumCoProcessor_256m = builder.defineInRange("quantum_coprocessor_256m", 8192, 0, 81920);
            builder.pop();
            this.spec = builder.build();
        }
    }

    public static class CommonConfig {
        public final ModConfigSpec spec;
        public final ModConfigSpec.EnumValue<MekRadialChemicalCheck> checkMode;

        public CommonConfig() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            this.checkMode = builder.comment("\u662f\u5426\u5141\u8bb8OMNI\u7cfb\u5217\u5143\u4ef6\u5b58\u5165MEK\u7684\u653e\u5c04\u6027\u5316\u5b66\u54c1\uff0cDENY_SPENT\u4ee3\u8868\u4ec5\u963b\u6b62\u7528\u5c3d\u7684\u6838\u5e9f\u6599\uff0c\u5176\u4f59\u4e3a\u5b57\u9762\u610f\u601d").defineEnum("mek_radial_chemical_check", (Enum)MekRadialChemicalCheck.DENY_SPENT);
            this.spec = builder.build();
        }

        public void onLoaded() {
            MekRadialChemicalCheckConfig.checkMode = (MekRadialChemicalCheck)((Object)this.checkMode.get());
        }
    }
}

