/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.client.me;

import appeng.api.client.StorageCellModels;
import com.wintercogs.ae2omnicells.AE2OmniCells;
import com.wintercogs.ae2omnicells.common.init.OCItems;
import com.wintercogs.ae2omnicells.common.items.AEPortableUniversalCellItem;
import com.wintercogs.ae2omnicells.common.items.AEUniversalCellItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.registries.DeferredItem;

public class AE2StorageModels {
    private static final String OMNI_MODEL_PREFIX = AE2OmniCells.makeId("drive/cells/omni/cell_").toString();
    private static final String COMPLEX_MODEL_PREFIX = AE2OmniCells.makeId("drive/cells/complex/cell_").toString();
    private static final String QUANTUM_MODEL_PREFIX = AE2OmniCells.makeId("drive/cells/quantum/cell_").toString();
    private static final ResourceLocation MODEL_CELL_CREATIVE = ResourceLocation.parse((String)"ae2:block/drive/cells/creative_cell");
    private static final ResourceLocation MODEL_SPENT_NUCLEAR_WASTE_CELL = AE2OmniCells.makeId("drive/cells/spent_nuclear_waste_cell");
    private static final String[] SUFFIXES = new String[]{"1k", "4k", "16k", "64k", "256k", "1m", "4m", "16m", "64m", "256m"};

    public static void registerStorageModels() {
        StorageCellModels.registerModel(OCItems.CREATIVE_AE_CELL_LONG, (ResourceLocation)MODEL_CELL_CREATIVE);
        StorageCellModels.registerModel(OCItems.CREATIVE_AE_CELL_BIGINTEGER, (ResourceLocation)MODEL_CELL_CREATIVE);
        StorageCellModels.registerModel(OCItems.SPENT_NUCLEAR_WASTE_CELL, (ResourceLocation)MODEL_SPENT_NUCLEAR_WASTE_CELL);
        AE2StorageModels.registerSeries(OMNI_MODEL_PREFIX, new DeferredItem[]{OCItems.OMNI_CELL_1K, OCItems.OMNI_CELL_4K, OCItems.OMNI_CELL_16K, OCItems.OMNI_CELL_64K, OCItems.OMNI_CELL_256K, OCItems.OMNI_CELL_1M, OCItems.OMNI_CELL_4M, OCItems.OMNI_CELL_16M, OCItems.OMNI_CELL_64M, OCItems.OMNI_CELL_256M}, new DeferredItem[]{OCItems.PORTABLE_OMNI_CELL_1K, OCItems.PORTABLE_OMNI_CELL_4K, OCItems.PORTABLE_OMNI_CELL_16K, OCItems.PORTABLE_OMNI_CELL_64K, OCItems.PORTABLE_OMNI_CELL_256K, OCItems.PORTABLE_OMNI_CELL_1M, OCItems.PORTABLE_OMNI_CELL_4M, OCItems.PORTABLE_OMNI_CELL_16M, OCItems.PORTABLE_OMNI_CELL_64M, OCItems.PORTABLE_OMNI_CELL_256M});
        AE2StorageModels.registerSeries(COMPLEX_MODEL_PREFIX, new DeferredItem[]{OCItems.COMPLEX_OMNI_CELL_1K, OCItems.COMPLEX_OMNI_CELL_4K, OCItems.COMPLEX_OMNI_CELL_16K, OCItems.COMPLEX_OMNI_CELL_64K, OCItems.COMPLEX_OMNI_CELL_256K, OCItems.COMPLEX_OMNI_CELL_1M, OCItems.COMPLEX_OMNI_CELL_4M, OCItems.COMPLEX_OMNI_CELL_16M, OCItems.COMPLEX_OMNI_CELL_64M, OCItems.COMPLEX_OMNI_CELL_256M}, new DeferredItem[]{OCItems.PORTABLE_COMPLEX_OMNI_CELL_1K, OCItems.PORTABLE_COMPLEX_OMNI_CELL_4K, OCItems.PORTABLE_COMPLEX_OMNI_CELL_16K, OCItems.PORTABLE_COMPLEX_OMNI_CELL_64K, OCItems.PORTABLE_COMPLEX_OMNI_CELL_256K, OCItems.PORTABLE_COMPLEX_OMNI_CELL_1M, OCItems.PORTABLE_COMPLEX_OMNI_CELL_4M, OCItems.PORTABLE_COMPLEX_OMNI_CELL_16M, OCItems.PORTABLE_COMPLEX_OMNI_CELL_64M, OCItems.PORTABLE_COMPLEX_OMNI_CELL_256M});
        AE2StorageModels.registerSeries(QUANTUM_MODEL_PREFIX, new DeferredItem[]{OCItems.QUANTUM_OMNI_CELL_1K, OCItems.QUANTUM_OMNI_CELL_4K, OCItems.QUANTUM_OMNI_CELL_16K, OCItems.QUANTUM_OMNI_CELL_64K, OCItems.QUANTUM_OMNI_CELL_256K, OCItems.QUANTUM_OMNI_CELL_1M, OCItems.QUANTUM_OMNI_CELL_4M, OCItems.QUANTUM_OMNI_CELL_16M, OCItems.QUANTUM_OMNI_CELL_64M, OCItems.QUANTUM_OMNI_CELL_256M}, new DeferredItem[]{OCItems.PORTABLE_QUANTUM_OMNI_CELL_1K, OCItems.PORTABLE_QUANTUM_OMNI_CELL_4K, OCItems.PORTABLE_QUANTUM_OMNI_CELL_16K, OCItems.PORTABLE_QUANTUM_OMNI_CELL_64K, OCItems.PORTABLE_QUANTUM_OMNI_CELL_256K, OCItems.PORTABLE_QUANTUM_OMNI_CELL_1M, OCItems.PORTABLE_QUANTUM_OMNI_CELL_4M, OCItems.PORTABLE_QUANTUM_OMNI_CELL_16M, OCItems.PORTABLE_QUANTUM_OMNI_CELL_64M, OCItems.PORTABLE_QUANTUM_OMNI_CELL_256M});
    }

    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((itemStack, idx) -> FastColor.ARGB32.opaque((int)AEUniversalCellItem.getColor(itemStack, idx)), new ItemLike[]{(ItemLike)OCItems.OMNI_CELL_1K.get(), (ItemLike)OCItems.OMNI_CELL_4K.get(), (ItemLike)OCItems.OMNI_CELL_16K.get(), (ItemLike)OCItems.OMNI_CELL_64K.get(), (ItemLike)OCItems.OMNI_CELL_256K.get(), (ItemLike)OCItems.OMNI_CELL_1M.get(), (ItemLike)OCItems.OMNI_CELL_4M.get(), (ItemLike)OCItems.OMNI_CELL_16M.get(), (ItemLike)OCItems.OMNI_CELL_64M.get(), (ItemLike)OCItems.OMNI_CELL_256M.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_1K.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_4K.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_16K.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_64K.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_256K.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_1M.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_4M.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_16M.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_64M.get(), (ItemLike)OCItems.COMPLEX_OMNI_CELL_256M.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_1K.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_4K.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_16K.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_64K.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_256K.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_1M.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_4M.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_16M.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_64M.get(), (ItemLike)OCItems.QUANTUM_OMNI_CELL_256M.get(), (ItemLike)OCItems.CREATIVE_AE_CELL_LONG.get(), (ItemLike)OCItems.CREATIVE_AE_CELL_BIGINTEGER.get(), (ItemLike)OCItems.SPENT_NUCLEAR_WASTE_CELL.get()});
        event.register((itemStack, idx) -> FastColor.ARGB32.opaque((int)AEPortableUniversalCellItem.getColor(itemStack, idx)), new ItemLike[]{(ItemLike)OCItems.PORTABLE_OMNI_CELL_1K.get(), (ItemLike)OCItems.PORTABLE_OMNI_CELL_4K.get(), (ItemLike)OCItems.PORTABLE_OMNI_CELL_16K.get(), (ItemLike)OCItems.PORTABLE_OMNI_CELL_64K.get(), (ItemLike)OCItems.PORTABLE_OMNI_CELL_256K.get(), (ItemLike)OCItems.PORTABLE_OMNI_CELL_1M.get(), (ItemLike)OCItems.PORTABLE_OMNI_CELL_4M.get(), (ItemLike)OCItems.PORTABLE_OMNI_CELL_16M.get(), (ItemLike)OCItems.PORTABLE_OMNI_CELL_64M.get(), (ItemLike)OCItems.PORTABLE_OMNI_CELL_256M.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_1K.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_4K.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_16K.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_64K.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_256K.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_1M.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_4M.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_16M.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_64M.get(), (ItemLike)OCItems.PORTABLE_COMPLEX_OMNI_CELL_256M.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_1K.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_4K.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_16K.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_64K.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_256K.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_1M.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_4M.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_16M.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_64M.get(), (ItemLike)OCItems.PORTABLE_QUANTUM_OMNI_CELL_256M.get()});
    }

    private static void registerSeries(String prefix, DeferredItem<? extends Item>[] nonPortable, DeferredItem<? extends Item>[] portable) {
        if (nonPortable.length != SUFFIXES.length || portable.length != SUFFIXES.length) {
            throw new IllegalArgumentException("Tier arrays must match SUFFIXES length: " + SUFFIXES.length);
        }
        for (int i = 0; i < SUFFIXES.length; ++i) {
            AE2StorageModels.registerModel(prefix, SUFFIXES[i], (ItemLike)nonPortable[i].get());
            AE2StorageModels.registerModel(prefix, SUFFIXES[i], (ItemLike)portable[i].get());
        }
    }

    private static void registerModel(String prefix, String cap, ItemLike item) {
        StorageCellModels.registerModel((ItemLike)item, (ResourceLocation)ResourceLocation.parse((String)(prefix + cap)));
    }
}

