/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.client.render;

import appeng.block.crafting.ICraftingUnitType;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.LightBakedModel;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.crafting.UnitBakedModel;
import com.wintercogs.ae2omnicells.AE2OmniCells;
import com.wintercogs.ae2omnicells.common.me.crafting.OmniCraftingFamily;
import com.wintercogs.ae2omnicells.common.me.crafting.OmniCraftingStorageType;
import com.wintercogs.ae2omnicells.common.me.crafting.OmniCraftingUnitType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;

public class OmniCraftingUnitModelProvider
extends AbstractCraftingUnitModelProvider<OmniCraftingUnitType> {
    private static final List<Material> MATERIALS = new ArrayList<Material>();
    protected static final Material OMNI_RING_CORNER = OmniCraftingUnitModelProvider.texture("omni_ring_corner");
    protected static final Material OMNI_RING_SIDE_HOR = OmniCraftingUnitModelProvider.texture("omni_ring_side_hor");
    protected static final Material OMNI_RING_SIDE_VER = OmniCraftingUnitModelProvider.texture("omni_ring_side_ver");
    protected static final Material OMNI_UNIT_BASE = OmniCraftingUnitModelProvider.texture("omni_unit_base");
    protected static final Material OMNI_LIGHT_BASE = OmniCraftingUnitModelProvider.texture("omni_light_base");
    protected static final Material OMNI_MONITOR_BASE = OmniCraftingUnitModelProvider.texture("monitor/omni_monitor_base");
    protected static final Material COMPLEX_RING_CORNER = OmniCraftingUnitModelProvider.texture("complex_ring_corner");
    protected static final Material COMPLEX_RING_SIDE_HOR = OmniCraftingUnitModelProvider.texture("complex_ring_side_hor");
    protected static final Material COMPLEX_RING_SIDE_VER = OmniCraftingUnitModelProvider.texture("complex_ring_side_ver");
    protected static final Material COMPLEX_UNIT_BASE = OmniCraftingUnitModelProvider.texture("complex_unit_base");
    protected static final Material COMPLEX_LIGHT_BASE = OmniCraftingUnitModelProvider.texture("complex_light_base");
    protected static final Material COMPLEX_MONITOR_BASE = OmniCraftingUnitModelProvider.texture("monitor/complex_monitor_base");
    protected static final Material QUANTUM_RING_CORNER = OmniCraftingUnitModelProvider.texture("quantum_ring_corner");
    protected static final Material QUANTUM_RING_SIDE_HOR = OmniCraftingUnitModelProvider.texture("quantum_ring_side_hor");
    protected static final Material QUANTUM_RING_SIDE_VER = OmniCraftingUnitModelProvider.texture("quantum_ring_side_ver");
    protected static final Material QUANTUM_UNIT_BASE = OmniCraftingUnitModelProvider.texture("quantum_unit_base");
    protected static final Material QUANTUM_LIGHT_BASE = OmniCraftingUnitModelProvider.texture("quantum_light_base");
    protected static final Material QUANTUM_MONITOR_BASE = OmniCraftingUnitModelProvider.texture("monitor/quantum_monitor_base");
    protected static final Material STORAGE_1K_LIGHT = OmniCraftingUnitModelProvider.texture("light/1k_storage_light");
    protected static final Material STORAGE_4K_LIGHT = OmniCraftingUnitModelProvider.texture("light/4k_storage_light");
    protected static final Material STORAGE_16K_LIGHT = OmniCraftingUnitModelProvider.texture("light/16k_storage_light");
    protected static final Material STORAGE_64K_LIGHT = OmniCraftingUnitModelProvider.texture("light/64k_storage_light");
    protected static final Material STORAGE_256K_LIGHT = OmniCraftingUnitModelProvider.texture("light/256k_storage_light");
    protected static final Material STORAGE_1M_LIGHT = OmniCraftingUnitModelProvider.texture("light/1m_storage_light");
    protected static final Material STORAGE_4M_LIGHT = OmniCraftingUnitModelProvider.texture("light/4m_storage_light");
    protected static final Material STORAGE_16M_LIGHT = OmniCraftingUnitModelProvider.texture("light/16m_storage_light");
    protected static final Material STORAGE_64M_LIGHT = OmniCraftingUnitModelProvider.texture("light/64m_storage_light");
    protected static final Material STORAGE_256M_LIGHT = OmniCraftingUnitModelProvider.texture("light/256m_storage_light");
    protected static final Material MONITOR_LIGHT_DARK = OmniCraftingUnitModelProvider.texture("ae2", "monitor_light_dark");
    protected static final Material MONITOR_LIGHT_MEDIUM = OmniCraftingUnitModelProvider.texture("ae2", "monitor_light_medium");
    protected static final Material MONITOR_LIGHT_BRIGHT = OmniCraftingUnitModelProvider.texture("ae2", "monitor_light_bright");

    public OmniCraftingUnitModelProvider(OmniCraftingUnitType type) {
        super((ICraftingUnitType)type);
    }

    public List<Material> getMaterials() {
        return Collections.unmodifiableList(MATERIALS);
    }

    public BakedModel getBakedModel(Function<Material, TextureAtlasSprite> spriteGetter) {
        Material ringCornerMaterial = switch (((OmniCraftingUnitType)this.type).family) {
            default -> throw new MatchException(null, null);
            case OmniCraftingFamily.OMNI -> OMNI_RING_CORNER;
            case OmniCraftingFamily.COMPLEX -> COMPLEX_RING_CORNER;
            case OmniCraftingFamily.QUANTUM -> QUANTUM_RING_CORNER;
        };
        Material ringSideHorMaterial = switch (((OmniCraftingUnitType)this.type).family) {
            default -> throw new MatchException(null, null);
            case OmniCraftingFamily.OMNI -> OMNI_RING_SIDE_HOR;
            case OmniCraftingFamily.COMPLEX -> COMPLEX_RING_SIDE_HOR;
            case OmniCraftingFamily.QUANTUM -> QUANTUM_RING_SIDE_HOR;
        };
        Material ringSideVerMaterial = switch (((OmniCraftingUnitType)this.type).family) {
            default -> throw new MatchException(null, null);
            case OmniCraftingFamily.OMNI -> OMNI_RING_SIDE_VER;
            case OmniCraftingFamily.COMPLEX -> COMPLEX_RING_SIDE_VER;
            case OmniCraftingFamily.QUANTUM -> QUANTUM_RING_SIDE_VER;
        };
        Material unitMaterial = switch (((OmniCraftingUnitType)this.type).family) {
            default -> throw new MatchException(null, null);
            case OmniCraftingFamily.OMNI -> OMNI_UNIT_BASE;
            case OmniCraftingFamily.COMPLEX -> COMPLEX_UNIT_BASE;
            case OmniCraftingFamily.QUANTUM -> QUANTUM_UNIT_BASE;
        };
        Material monitorMaterial = switch (((OmniCraftingUnitType)this.type).family) {
            default -> throw new MatchException(null, null);
            case OmniCraftingFamily.OMNI -> OMNI_MONITOR_BASE;
            case OmniCraftingFamily.COMPLEX -> COMPLEX_MONITOR_BASE;
            case OmniCraftingFamily.QUANTUM -> QUANTUM_MONITOR_BASE;
        };
        TextureAtlasSprite ringCorner = spriteGetter.apply(ringCornerMaterial);
        TextureAtlasSprite ringSideHor = spriteGetter.apply(ringSideHorMaterial);
        TextureAtlasSprite ringSideVer = spriteGetter.apply(ringSideVerMaterial);
        return switch (((OmniCraftingUnitType)this.type).storageType) {
            case OmniCraftingStorageType.UNIT -> new UnitBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(unitMaterial));
            case OmniCraftingStorageType.MONITOR -> new MonitorBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(unitMaterial), spriteGetter.apply(monitorMaterial), spriteGetter.apply(MONITOR_LIGHT_DARK), spriteGetter.apply(MONITOR_LIGHT_MEDIUM), spriteGetter.apply(MONITOR_LIGHT_BRIGHT));
            default -> {
                Material v6 = switch (((OmniCraftingUnitType)this.type).family) {
                    default -> throw new MatchException(null, null);
                    case OmniCraftingFamily.OMNI -> OMNI_LIGHT_BASE;
                    case OmniCraftingFamily.COMPLEX -> COMPLEX_LIGHT_BASE;
                    case OmniCraftingFamily.QUANTUM -> QUANTUM_LIGHT_BASE;
                };
                Material lightBaseMaterial = v6;
                Material v7 = switch (((OmniCraftingUnitType)this.type).storageType) {
                    case OmniCraftingStorageType.STORAGE_1K -> STORAGE_1K_LIGHT;
                    case OmniCraftingStorageType.STORAGE_4K -> STORAGE_4K_LIGHT;
                    case OmniCraftingStorageType.STORAGE_16K -> STORAGE_16K_LIGHT;
                    case OmniCraftingStorageType.STORAGE_64K -> STORAGE_64K_LIGHT;
                    case OmniCraftingStorageType.STORAGE_256K -> STORAGE_256K_LIGHT;
                    case OmniCraftingStorageType.STORAGE_1M -> STORAGE_1M_LIGHT;
                    case OmniCraftingStorageType.STORAGE_4M -> STORAGE_4M_LIGHT;
                    case OmniCraftingStorageType.STORAGE_16M -> STORAGE_16M_LIGHT;
                    case OmniCraftingStorageType.STORAGE_64M -> STORAGE_64M_LIGHT;
                    case OmniCraftingStorageType.STORAGE_256M -> STORAGE_256M_LIGHT;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)((OmniCraftingUnitType)this.type).storageType));
                };
                Material lightMaterial = v7;
                yield new LightBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(lightBaseMaterial), spriteGetter.apply(lightMaterial));
            }
        };
    }

    private static Material texture(String name) {
        Material mat = new Material(TextureAtlas.LOCATION_BLOCKS, AE2OmniCells.makeId("block/crafting/" + name));
        MATERIALS.add(mat);
        return mat;
    }

    private static Material texture(String namespace, String name) {
        Material mat = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("block/crafting/" + name)));
        MATERIALS.add(mat);
        return mat;
    }
}

