/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.init;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.crafting.CraftingMonitorBlockEntity;
import com.google.common.base.Preconditions;
import com.wintercogs.ae2omnicells.common.blocks.entities.OmniCraftingBlockEntity;
import com.wintercogs.ae2omnicells.common.init.OCBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class OCBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"ae2omnicells");
    private static final List<DeferredBlockEntityType<?>> ALL = new ArrayList();
    public static final DeferredBlockEntityType<OmniCraftingBlockEntity> OMNI_CRAFTING_BLOCK_ENTITY = OCBlockEntities.create("omni_crafting_block_entity", OmniCraftingBlockEntity.class, OmniCraftingBlockEntity::new, OCBlocks.CRAFTING_STORAGES.toArray(new Supplier[0]));
    public static final DeferredBlockEntityType<CraftingMonitorBlockEntity> OMNI_CRAFTING_MONITOR_BLOCK_ENTITY = OCBlockEntities.create("omni_crating_monitor_block_entity", CraftingMonitorBlockEntity.class, CraftingMonitorBlockEntity::new, OCBlocks.CRAFTING_MONITORS.toArray(new Supplier[0]));

    public static void register(IEventBus eventBus) {
        BLOCK_ENTITY_TYPES.register(eventBus);
    }

    @SafeVarargs
    public static <T extends AEBaseBlockEntity> DeferredBlockEntityType<T> create(String id, Class<T> entityClass, BlockEntityFactory<T> factory, Supplier<? extends AEBaseEntityBlock<?>> ... blockSuppliers) {
        Preconditions.checkArgument((blockSuppliers.length > 0 ? 1 : 0) != 0, (Object)"At least one block is required");
        DeferredHolder deferred = BLOCK_ENTITY_TYPES.register(id, () -> {
            AtomicReference<BlockEntityType> typeRef = new AtomicReference<BlockEntityType>();
            BlockEntityType.BlockEntitySupplier supplier = (pos, state) -> factory.create((BlockEntityType)typeRef.get(), pos, state);
            AEBaseEntityBlock[] blocks = (AEBaseEntityBlock[])Arrays.stream(blockSuppliers).map(Supplier::get).toArray(AEBaseEntityBlock[]::new);
            Block[] vanillaBlocks = (Block[])Arrays.stream(blocks).toArray(Block[]::new);
            BlockEntityType type = BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)supplier, (Block[])vanillaBlocks).build(null);
            typeRef.set(type);
            try {
                Item item = blocks[0].asItem();
                AEBaseBlockEntity.registerBlockEntityItem((BlockEntityType)type, (Item)item);
            }
            catch (Throwable item) {
                // empty catch block
            }
            BlockEntityTicker serverTicker = null;
            if (ServerTickingBlockEntity.class.isAssignableFrom(entityClass)) {
                serverTicker = (lvl, p, st, be) -> ((ServerTickingBlockEntity)be).serverTick();
            }
            BlockEntityTicker clientTicker = null;
            if (ClientTickingBlockEntity.class.isAssignableFrom(entityClass)) {
                clientTicker = (lvl, p, st, be) -> ((ClientTickingBlockEntity)be).clientTick();
            }
            AEBaseEntityBlock[] aEBaseEntityBlockArray = blocks;
            int n = aEBaseEntityBlockArray.length;
            for (int i = 0; i < n; ++i) {
                AEBaseEntityBlock b;
                AEBaseEntityBlock base = b = aEBaseEntityBlockArray[i];
                base.setBlockEntity(entityClass, type, clientTicker, serverTicker);
            }
            return type;
        });
        DeferredBlockEntityType<T> wrapped = new DeferredBlockEntityType<T>(entityClass, deferred);
        ALL.add(wrapped);
        return wrapped;
    }

    @SafeVarargs
    public static <T extends AEBaseBlockEntity> DeferredBlockEntityType<T> create(String id, Class<T> entityClass, BiFunction<BlockPos, BlockState, T> ctorPosState, Supplier<? extends AEBaseEntityBlock<?>> ... blockSuppliers) {
        return OCBlockEntities.create(id, entityClass, (BlockEntityType<T> type, BlockPos pos, BlockState state) -> (AEBaseBlockEntity)ctorPosState.apply(pos, state), blockSuppliers);
    }

    public static <T extends BlockEntity> List<BlockEntityType<? extends T>> getSubclassesOf(Class<T> baseClass) {
        ArrayList<BlockEntityType<T>> result = new ArrayList<BlockEntityType<T>>();
        for (DeferredBlockEntityType<?> t : ALL) {
            if (!baseClass.isAssignableFrom(t.getBlockEntityClass())) continue;
            result.add(t.get());
        }
        return result;
    }

    public static List<BlockEntityType<?>> getImplementorsOf(Class<?> iface) {
        ArrayList result = new ArrayList();
        for (DeferredBlockEntityType<?> t : ALL) {
            if (!iface.isAssignableFrom(t.getBlockEntityClass())) continue;
            result.add(t.get());
        }
        return result;
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends AEBaseBlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }

    public static final class DeferredBlockEntityType<T extends BlockEntity>
    implements Supplier<BlockEntityType<T>> {
        private final Class<T> entityClass;
        private final Supplier<BlockEntityType<T>> delegate;

        private DeferredBlockEntityType(Class<T> cls, Supplier<BlockEntityType<T>> delegate) {
            this.entityClass = cls;
            this.delegate = delegate;
        }

        @Override
        public BlockEntityType<T> get() {
            return this.delegate.get();
        }

        public Class<T> getBlockEntityClass() {
            return this.entityClass;
        }
    }
}

