/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.items;

import appeng.api.config.FuzzyMode;
import appeng.api.ids.AEComponents;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.CellState;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.core.AEConfig;
import appeng.items.contents.CellConfig;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.items.tools.powered.PoweredContainerItem;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import appeng.util.ConfigInventory;
import appeng.util.Platform;
import com.wintercogs.ae2omnicells.AE2OmniCells;
import com.wintercogs.ae2omnicells.common.init.OCItems;
import com.wintercogs.ae2omnicells.common.me.IAEUniversalCell;
import com.wintercogs.ae2omnicells.common.me.localization.AEUniversalTooltips;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class AEPortableUniversalCellItem
extends AbstractPortableCell
implements IAEUniversalCell {
    private static final int DEFAULT_COLOR = 0xFFFFFF;
    private final double idleDrain;
    private final int totalBytes;
    private final int totalTypes;

    public AEPortableUniversalCellItem(MenuType<?> menuType, Item.Properties props, int totalTypes, int kiloBytes, double idleDrain) {
        super(menuType, props, 0xFFFFFF);
        this.idleDrain = idleDrain;
        this.totalBytes = kiloBytes > 0 ? kiloBytes * 1024 : -1;
        this.totalTypes = totalTypes;
    }

    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        for (DeferredItem<AEPortableUniversalCellItem> item : OCItems.getPortableCells()) {
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, unused) -> new PoweredItemCapabilities(stack, (IAEItemPowerStorage)item.get()), new ItemLike[]{item});
        }
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return 8440575;
        }
        if (tintIndex == 1) {
            PoweredContainerItem poweredContainer;
            Item item = stack.getItem();
            if (item instanceof PoweredContainerItem && (poweredContainer = (PoweredContainerItem)item).getAECurrentPower(stack) <= 0.0) {
                return CellState.ABSENT.getStateColor();
            }
            return IAEUniversalCell.getCellState(stack).getStateColor();
        }
        return 0xFFFFFF;
    }

    public ResourceLocation getRecipeId() {
        return AE2OmniCells.makeId("cells/shapeless/" + Objects.requireNonNull(this.getRegistryName()).getPath());
    }

    public double getChargeRate(ItemStack stack) {
        return 80.0 + 80.0 * (double)Upgrades.getEnergyCardMultiplier((IUpgradeInventory)this.getUpgrades(stack));
    }

    @Override
    public int getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public int getTotalTypes() {
        return this.totalTypes;
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)6, (arg_0, arg_1) -> ((AEPortableUniversalCellItem)this).onUpgradesChanged(arg_0, arg_1));
    }

    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create((ItemStack)is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return (FuzzyMode)is.getOrDefault(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)FuzzyMode.IGNORE_ALL);
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.set(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)fzMode);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        super.appendHoverText(stack, context, lines, advancedTooltips);
        if (Platform.isClient()) {
            long usedBytes = IAEUniversalCell.getUsedBytes(stack);
            long usedTypes = IAEUniversalCell.getUsedTypes(stack);
            lines.add(AEUniversalTooltips.bytesUsed(usedBytes, (long)this.getTotalBytes()));
            lines.add(AEUniversalTooltips.typesUsed(usedTypes, this.getTotalTypes()));
        }
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        List<GenericStack> show;
        boolean showUpg = AEConfig.instance().isTooltipShowCellUpgrades();
        boolean showCnt = AEConfig.instance().isTooltipShowCellContent();
        if (!showUpg && !showCnt) {
            return Optional.empty();
        }
        List upgrades = Collections.emptyList();
        if (showUpg) {
            ArrayList tmp = new ArrayList();
            this.getUpgrades(stack).forEach(tmp::add);
            upgrades = tmp;
        }
        List content = Collections.emptyList();
        boolean hasMore = false;
        if (showCnt && !(show = IAEUniversalCell.getTooltipShowStacks(stack)).isEmpty()) {
            int limit = 5;
            if (show.size() > 5) {
                content = new ArrayList<GenericStack>(show.subList(0, 5));
                hasMore = true;
            } else {
                content = new ArrayList<GenericStack>(show);
            }
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, hasMore, true));
    }
}

