/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.items;

import appeng.block.crafting.CraftingBlockItem;
import appeng.core.definitions.AEParts;
import appeng.recipes.game.CraftingUnitTransformRecipe;
import appeng.util.InteractionUtil;
import com.wintercogs.ae2omnicells.common.blocks.OmniCraftingMonitorBlock;
import com.wintercogs.ae2omnicells.common.me.crafting.OmniCraftingFamily;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class OmniCraftingBlockItem
extends CraftingBlockItem {
    private final OmniCraftingFamily family;

    public OmniCraftingBlockItem(Block id, Item.Properties props, OmniCraftingFamily family) {
        super(id, props);
        this.family = family;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            ItemStack stack = player.getItemInHand(hand);
            ItemStack removedUpgrade = this.getBlock() instanceof OmniCraftingMonitorBlock ? AEParts.STORAGE_MONITOR.stack() : CraftingUnitTransformRecipe.getRemovedUpgrade((Level)level, (Block)this.getBlock());
            if (removedUpgrade.isEmpty()) {
                return super.use(level, player, hand);
            }
            int itemCount = stack.getCount();
            player.setItemInHand(hand, ItemStack.EMPTY);
            Inventory inv = player.getInventory();
            inv.placeItemBackInInventory(removedUpgrade.copyWithCount(removedUpgrade.getCount() * itemCount));
            Block unitBlock = this.family.getUnitBaseBlock();
            inv.placeItemBackInInventory(new ItemStack((ItemLike)unitBlock, itemCount));
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
        }
        return super.use(level, player, hand);
    }
}

