/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.me;

import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import com.wintercogs.ae2omnicells.common.me.AEUniversalCellData;
import com.wintercogs.ae2omnicells.common.me.AEUniversalCellInventory;
import com.wintercogs.ae2omnicells.common.me.IAEUniversalCell;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class AEUniversalCellHandler
implements ICellHandler {
    public static final AEUniversalCellHandler INSTANCE = new AEUniversalCellHandler();

    private AEUniversalCellHandler() {
    }

    public boolean isCell(ItemStack itemStack) {
        return itemStack.getItem() instanceof IAEUniversalCell && itemStack.getCount() == 1;
    }

    @Nullable
    public StorageCell getCellInventory(ItemStack itemStack, @Nullable ISaveProvider iSaveProvider) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return null;
        }
        Item item = itemStack.getItem();
        if (!(item instanceof IAEUniversalCell)) {
            return null;
        }
        IAEUniversalCell cellItem = (IAEUniversalCell)item;
        if (itemStack.getCount() != 1) {
            return null;
        }
        AEUniversalCellData cellData = AEUniversalCellData.computeIfAbsentCellDataForItemStack(itemStack);
        if (cellData == null) {
            return null;
        }
        return new AEUniversalCellInventory(cellData, itemStack, cellItem, iSaveProvider);
    }
}

