/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.me;

import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.CellState;
import appeng.api.upgrades.IUpgradeableItem;
import com.wintercogs.ae2omnicells.common.init.OCDataComponents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public interface IAEUniversalCell
extends IUpgradeableItem {
    public int getTotalBytes();

    public int getTotalTypes();

    public double getIdleDrain();

    public static long getUsedBytes(ItemStack stack) {
        Long v = (Long)stack.get((DataComponentType)OCDataComponents.CELL_BYTES_USAGE.get());
        return v == null ? 0L : v;
    }

    public static void setUsedBytes(ItemStack stack, long usedBytes) {
        stack.set((DataComponentType)OCDataComponents.CELL_BYTES_USAGE.get(), (Object)Math.max(0L, usedBytes));
    }

    public static int getUsedTypes(ItemStack stack) {
        Integer v = (Integer)stack.get((DataComponentType)OCDataComponents.CELL_TYPES_USAGE.get());
        return v == null ? 0 : v;
    }

    public static void setUsedTypes(ItemStack stack, int usedTypes) {
        stack.set((DataComponentType)OCDataComponents.CELL_TYPES_USAGE.get(), (Object)Math.max(0, usedTypes));
    }

    public static CellState getCellState(ItemStack stack) {
        String s = (String)stack.get((DataComponentType)OCDataComponents.CELL_STATE.get());
        if (s == null) {
            return CellState.EMPTY;
        }
        try {
            return CellState.valueOf((String)s);
        }
        catch (IllegalArgumentException ex) {
            return CellState.EMPTY;
        }
    }

    public static void setCellState(ItemStack stack, IAEUniversalCell cellType, long usedBytes, int usedTypes) {
        int totalBytes = cellType.getTotalBytes();
        int totalTypes = cellType.getTotalTypes();
        CellState state = usedBytes <= 0L && usedTypes <= 0 ? CellState.EMPTY : (totalBytes > 0 && usedBytes >= (long)totalBytes ? CellState.FULL : (totalTypes > 0 && usedTypes >= totalTypes ? CellState.TYPES_FULL : CellState.NOT_EMPTY));
        stack.set((DataComponentType)OCDataComponents.CELL_STATE.get(), (Object)state.name());
    }

    public static List<GenericStack> getTooltipShowStacks(ItemStack stack) {
        List raw = (List)stack.get((DataComponentType)OCDataComponents.CELL_SHOW_TOOLTIP_STACKS.get());
        if (raw == null || raw.isEmpty()) {
            return List.of();
        }
        return Collections.unmodifiableList(new ArrayList(raw));
    }

    public static void setTooltipShowStacks(ItemStack stack, List<GenericStack> showStacks) {
        if (showStacks == null || showStacks.isEmpty()) {
            stack.remove((DataComponentType)OCDataComponents.CELL_SHOW_TOOLTIP_STACKS.get());
            return;
        }
        ArrayList<GenericStack> cleaned = new ArrayList<GenericStack>(showStacks.size());
        for (GenericStack gs : showStacks) {
            if (gs == null) continue;
            cleaned.add(gs);
        }
        if (cleaned.isEmpty()) {
            stack.remove((DataComponentType)OCDataComponents.CELL_SHOW_TOOLTIP_STACKS.get());
        } else {
            stack.set((DataComponentType)OCDataComponents.CELL_SHOW_TOOLTIP_STACKS.get(), cleaned);
        }
    }
}

