/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.datagen;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import com.wintercogs.ae2omnicells.AE2OmniCells;
import com.wintercogs.ae2omnicells.common.blocks.OmniCraftingUnitBlock;
import com.wintercogs.ae2omnicells.common.init.OCBlocks;
import com.wintercogs.ae2omnicells.datagen.provider.CustomizableBlockModelProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

public class ModBlockStateProvider
extends BlockStateProvider {
    private final CustomizableBlockModelProvider ae2Models;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "ae2omnicells", exFileHelper);
        this.ae2Models = new CustomizableBlockModelProvider(output, "ae2", exFileHelper);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        this.ae2Models.clearForInternal();
        CompletableFuture base = super.run(cache);
        CompletableFuture<?> ae2 = this.ae2Models.generateAllForInternal(cache);
        return CompletableFuture.allOf(base, ae2);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(OCBlocks.ENDER_INGOT_BLOCK);
        this.blockWithItem(OCBlocks.NETHERITE_SCRAP_BLOCK);
        this.blockWithItem(OCBlocks.SINGULARITY_BLOCK);
        for (DeferredBlock<? extends OmniCraftingUnitBlock> craftingBlock : OCBlocks.CRAFTING_STORAGES) {
            this.craftingModel(craftingBlock);
        }
    }

    private void blockWithItem(DeferredBlock<Block> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void craftingModel(DeferredBlock<? extends OmniCraftingUnitBlock> block) {
        String path = block.getId().getPath();
        BlockModelBuilder blockModel = (BlockModelBuilder)this.models().cubeAll("block/crafting/" + path, AE2OmniCells.makeId("block/crafting/" + path));
        ModelBuilder formed = this.ae2Models.getBuilder("block/crafting/" + path + "_formed");
        this.getVariantBuilder((Block)block.get()).partialState().with((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)blockModel)}).partialState().with((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)formed)});
        this.simpleBlockItem((Block)block.get(), (ModelFile)blockModel);
    }
}

