/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.common.me;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.IPartitionList;
import com.wintercogs.ae2omnicells.common.me.AEUniversalCellData;
import com.wintercogs.ae2omnicells.common.me.IAEUniversalCell;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AEUniversalCellInventory
implements StorageCell {
    @NotNull
    private final AEUniversalCellData cellData;
    @NotNull
    private final Object2LongMap<AEKey> storage;
    @NotNull
    private final ItemStack itemStack;
    @NotNull
    private final IAEUniversalCell cellType;
    private final long totalBytesEff;
    private final long totalTypesEff;
    private long usedBytesCached;
    private long storedTypesCached;
    private final Long2LongOpenHashMap bucketSums = new Long2LongOpenHashMap();

    public AEUniversalCellInventory(@NotNull AEUniversalCellData cellData, @NotNull ItemStack itemStack, @NotNull IAEUniversalCell cellType) {
        long apb;
        this.cellData = cellData;
        this.storage = cellData.getOriginalStorage();
        this.itemStack = itemStack;
        this.cellType = cellType;
        this.bucketSums.defaultReturnValue(0L);
        long totalBytes = cellType.getTotalBytes();
        this.totalBytesEff = totalBytes <= 0L ? Long.MAX_VALUE : totalBytes;
        long totalTypes = cellType.getTotalTypes();
        this.totalTypesEff = totalTypes <= 0L ? Long.MAX_VALUE : totalTypes;
        long types = 0L;
        for (Object2LongMap.Entry e : this.storage.object2LongEntrySet()) {
            long v = e.getLongValue();
            if (v <= 0L) continue;
            ++types;
            apb = Math.max(1, ((AEKey)e.getKey()).getType().getAmountPerByte());
            this.bucketSums.addTo(apb, v);
        }
        this.storedTypesCached = types;
        long bytesForValues = 0L;
        for (Long2LongMap.Entry b : this.bucketSums.long2LongEntrySet()) {
            apb = b.getLongKey();
            long sum = b.getLongValue();
            bytesForValues = AEUniversalCellInventory.safeAdd(bytesForValues, AEUniversalCellInventory.ceilDiv(sum, apb));
        }
        this.usedBytesCached = bytesForValues;
        this.updateItemTooltipState();
    }

    public CellState getStatus() {
        if (this.storedTypesCached == 0L) {
            return CellState.EMPTY;
        }
        long freeBytes = this.freeBytes();
        boolean canOpenNewType = this.canHoldNewItemGeneric(freeBytes);
        if (canOpenNewType) {
            return CellState.NOT_EMPTY;
        }
        boolean hasPartial = this.hasAnyBucketPartial() || freeBytes > 0L;
        return hasPartial ? CellState.TYPES_FULL : CellState.FULL;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    public boolean canFitInsideCell() {
        return true;
    }

    public void persist() {
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        long canGrowBy;
        long maxPerTypeCap;
        if (amount <= 0L) {
            return 0L;
        }
        if (!this.matchesPartitionAndUpgrades(what)) {
            return 0L;
        }
        if (!this.canNestStorageCells(what)) {
            return 0L;
        }
        long amountPerByte = Math.max(1, what.getType().getAmountPerByte());
        long current = this.storage.getLong((Object)what);
        long freeBytes = this.freeBytes();
        boolean openingNewType = current <= 0L;
        long allowedUnits = this.remainingUnitsIntoExistingFor(amountPerByte, freeBytes);
        if (openingNewType) {
            if (this.storedTypesCached >= this.totalTypesEff) {
                return this.handleOverflowVoidOnInsert(what, amount, 0L);
            }
            if (allowedUnits <= 0L) {
                return this.handleOverflowVoidOnInsert(what, amount, 0L);
            }
        }
        if ((maxPerTypeCap = this.computeEqualDistributionCap(amountPerByte)) != Long.MAX_VALUE && (allowedUnits = Math.min(allowedUnits, canGrowBy = Math.max(0L, maxPerTypeCap - current))) <= 0L) {
            return this.handleOverflowVoidOnInsert(what, amount, 0L);
        }
        long toInsert = Math.min(amount, allowedUnits);
        if (toInsert <= 0L) {
            return 0L;
        }
        if (mode == Actionable.MODULATE) {
            long oldBucket = this.bucketSums.get(amountPerByte);
            long newBucket = AEUniversalCellInventory.safeAdd(oldBucket, toInsert);
            long deltaValueBytes = AEUniversalCellInventory.safeSub(AEUniversalCellInventory.ceilDiv(newBucket, amountPerByte), AEUniversalCellInventory.ceilDiv(oldBucket, amountPerByte));
            if (openingNewType) {
                this.storedTypesCached = AEUniversalCellInventory.safeAdd(this.storedTypesCached, 1L);
            }
            this.usedBytesCached = AEUniversalCellInventory.safeAdd(this.usedBytesCached, deltaValueBytes);
            this.bucketSums.put(amountPerByte, newBucket);
            this.storage.put((Object)what, AEUniversalCellInventory.safeAdd(current, toInsert));
            this.afterMutationUpdateClientAndSave();
        }
        return toInsert;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount <= 0L) {
            return 0L;
        }
        long current = this.storage.getLong((Object)what);
        if (current <= 0L) {
            return 0L;
        }
        long taken = Math.min(amount, current);
        if (mode == Actionable.MODULATE) {
            long amountPerByte = Math.max(1, what.getType().getAmountPerByte());
            long oldBucket = this.bucketSums.get(amountPerByte);
            long newBucket = Math.max(0L, oldBucket - taken);
            long deltaValueBytes = AEUniversalCellInventory.safeSub(AEUniversalCellInventory.ceilDiv(newBucket, amountPerByte), AEUniversalCellInventory.ceilDiv(oldBucket, amountPerByte));
            this.usedBytesCached = AEUniversalCellInventory.safeAdd(this.usedBytesCached, deltaValueBytes);
            long next = current - taken;
            if (next > 0L) {
                this.storage.put((Object)what, next);
            } else {
                this.storage.removeLong((Object)what);
                this.storedTypesCached = Math.max(0L, this.storedTypesCached - 1L);
            }
            if (newBucket > 0L) {
                this.bucketSums.put(amountPerByte, newBucket);
            } else {
                this.bucketSums.remove(amountPerByte);
            }
            this.afterMutationUpdateClientAndSave();
        }
        return taken;
    }

    public void getAvailableStacks(KeyCounter out) {
        for (Object2LongMap.Entry entry : this.storage.object2LongEntrySet()) {
            long value = entry.getLongValue();
            if (value <= 0L) continue;
            out.add((AEKey)entry.getKey(), value);
        }
    }

    public Component getDescription() {
        return this.itemStack.getHoverName();
    }

    private long freeBytes() {
        if (this.totalBytesEff == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long freeBytes = this.totalBytesEff - this.usedBytesCached;
        return Math.max(0L, freeBytes);
    }

    private boolean canHoldNewItemGeneric(long freeBytes) {
        if (this.storedTypesCached >= this.totalTypesEff) {
            return false;
        }
        if (freeBytes > 0L) {
            return true;
        }
        return this.hasAnyBucketPartial();
    }

    private boolean hasAnyBucketPartial() {
        for (Long2LongMap.Entry bucket : this.bucketSums.long2LongEntrySet()) {
            long apb = bucket.getLongKey();
            long sum = bucket.getLongValue();
            if (sum <= 0L || sum % apb == 0L) continue;
            return true;
        }
        return false;
    }

    private long remainingUnitsIntoExistingFor(long amountPerByte, long freeBytes) {
        long pad;
        long sum = this.bucketSums.get(amountPerByte);
        long l = pad = sum == 0L ? 0L : (amountPerByte - sum % amountPerByte) % amountPerByte;
        if (freeBytes == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long extra = AEUniversalCellInventory.safeMul(freeBytes, amountPerByte);
        return AEUniversalCellInventory.safeAdd(pad, extra);
    }

    private boolean canNestStorageCells(AEKey what) {
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            ItemStack s = itemKey.toStack();
            StorageCell nested = StorageCells.getCellInventory((ItemStack)s, null);
            return nested == null || nested.canFitInsideCell();
        }
        return true;
    }

    private boolean matchesPartitionAndUpgrades(AEKey what) {
        IUpgradeInventory upgrades = this.cellType.getUpgrades(this.itemStack);
        boolean hasInverter = upgrades.isInstalled((ItemLike)AEItems.INVERTER_CARD);
        boolean hasFuzzy = upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD);
        ConfigInventory config = null;
        FuzzyMode fuzzyMode = FuzzyMode.IGNORE_ALL;
        IAEUniversalCell iAEUniversalCell = this.cellType;
        if (iAEUniversalCell instanceof ICellWorkbenchItem) {
            ICellWorkbenchItem cellWorkbenchItem = (ICellWorkbenchItem)iAEUniversalCell;
            config = cellWorkbenchItem.getConfigInventory(this.itemStack);
            if (hasFuzzy) {
                fuzzyMode = cellWorkbenchItem.getFuzzyMode(this.itemStack);
            }
        }
        if (config == null || config.keySet().isEmpty()) {
            return true;
        }
        IPartitionList.Builder builder = IPartitionList.builder();
        if (hasFuzzy) {
            builder.fuzzyMode(fuzzyMode);
        }
        builder.addAll((Iterable)config.keySet());
        IPartitionList list = builder.build();
        IncludeExclude mode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        return list.matchesFilter(what, mode);
    }

    private long computeEqualDistributionCap(long apb) {
        ConfigInventory config;
        IUpgradeInventory upgrades = this.cellType.getUpgrades(this.itemStack);
        if (!upgrades.isInstalled((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD)) {
            return Long.MAX_VALUE;
        }
        boolean hasFuzzy = upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD);
        boolean whitelist = !upgrades.isInstalled((ItemLike)AEItems.INVERTER_CARD);
        long estimatedTypes = Long.MAX_VALUE;
        IAEUniversalCell iAEUniversalCell = this.cellType;
        if (iAEUniversalCell instanceof ICellWorkbenchItem) {
            ICellWorkbenchItem cwi = (ICellWorkbenchItem)iAEUniversalCell;
            v0 = cwi.getConfigInventory(this.itemStack);
        } else {
            v0 = config = null;
        }
        if (!hasFuzzy && whitelist && config != null && !config.keySet().isEmpty()) {
            estimatedTypes = config.keySet().size();
        }
        if ((estimatedTypes = Math.min(estimatedTypes, this.totalTypesEff)) <= 0L) {
            return 0L;
        }
        if (this.totalBytesEff == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long netBytes = this.totalBytesEff;
        long units = AEUniversalCellInventory.safeMul(netBytes, apb);
        return AEUniversalCellInventory.ceilDiv(units, estimatedTypes);
    }

    private long handleOverflowVoidOnInsert(AEKey what, long amount, long inserted) {
        IUpgradeInventory upgrades = this.cellType.getUpgrades(this.itemStack);
        if (!upgrades.isInstalled((ItemLike)AEItems.VOID_CARD)) {
            return inserted;
        }
        boolean unpartitioned = true;
        IAEUniversalCell iAEUniversalCell = this.cellType;
        if (iAEUniversalCell instanceof ICellWorkbenchItem) {
            ICellWorkbenchItem cellWorkbenchItem = (ICellWorkbenchItem)iAEUniversalCell;
            ConfigInventory configInventory = cellWorkbenchItem.getConfigInventory(this.itemStack);
            unpartitioned = configInventory == null || configInventory.keySet().isEmpty();
        }
        long freeBytes = this.freeBytes();
        boolean canOpen = this.canHoldNewItemGeneric(freeBytes);
        if (unpartitioned && !canOpen) {
            boolean exists = this.storage.getLong((Object)what) > 0L;
            return exists ? amount : inserted;
        }
        return amount;
    }

    private void afterMutationUpdateClientAndSave() {
        this.updateItemTooltipState();
        this.cellData.setDirty();
    }

    private void updateItemTooltipState() {
        int usedBytesClamped = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, this.usedBytesCached));
        int usedTypesClamped = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, this.storedTypesCached));
        IAEUniversalCell.setUsedBytes(this.itemStack, usedBytesClamped);
        IAEUniversalCell.setUsedTypes(this.itemStack, usedTypesClamped);
        IAEUniversalCell.setCellState(this.itemStack, this.cellType, usedBytesClamped, usedTypesClamped);
        ArrayList<GenericStack> show = new ArrayList<GenericStack>(5);
        int count = 0;
        for (Object2LongMap.Entry e : this.storage.object2LongEntrySet()) {
            long v = e.getLongValue();
            if (v <= 0L) continue;
            show.add(new GenericStack((AEKey)e.getKey(), v));
            if (++count < 5) continue;
            break;
        }
        IAEUniversalCell.setTooltipShowStacks(this.itemStack, show);
    }

    private static long ceilDiv(long a, long b) {
        if (b <= 0L) {
            throw new IllegalArgumentException("div by non-positive");
        }
        if (a <= 0L) {
            return 0L;
        }
        long q = a / b;
        long r = a % b;
        return r == 0L ? q : q + 1L;
    }

    private static long safeAdd(long a, long b) {
        long r = a + b;
        if (((a ^ r) & (b ^ r)) < 0L) {
            return Long.MAX_VALUE;
        }
        return r;
    }

    private static long safeSub(long a, long b) {
        long r = a - b;
        if (((a ^ b) & (a ^ r)) < 0L) {
            return Long.MIN_VALUE;
        }
        return r;
    }

    private static long safeMul(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        if (a > Long.MAX_VALUE / b) {
            return Long.MAX_VALUE;
        }
        return a * b;
    }
}

