/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.ae2omnicells.datagen.builder;

import appeng.recipes.game.StorageCellDisassemblyRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class CellDisassemblyRecipeBuilder {
    private final ItemLike cell;
    private final List<ItemStack> outputs = new ArrayList<ItemStack>();
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private String overrideNamespace = null;
    private String folder = "";

    private CellDisassemblyRecipeBuilder(ItemLike cell) {
        this.cell = Objects.requireNonNull(cell, "cell");
    }

    public static CellDisassemblyRecipeBuilder cell(ItemLike cell) {
        return new CellDisassemblyRecipeBuilder(cell);
    }

    public CellDisassemblyRecipeBuilder add(ItemLike item) {
        return this.add(item, 1);
    }

    public CellDisassemblyRecipeBuilder add(ItemLike item, int count) {
        this.outputs.add(new ItemStack((ItemLike)item.asItem(), count));
        return this;
    }

    public CellDisassemblyRecipeBuilder add(ItemStack stack) {
        this.outputs.add(stack.copy());
        return this;
    }

    public CellDisassemblyRecipeBuilder when(ICondition condition) {
        this.conditions.add(Objects.requireNonNull(condition));
        return this;
    }

    public CellDisassemblyRecipeBuilder whenModLoaded(String modid) {
        return this.when((ICondition)new ModLoadedCondition(modid));
    }

    public CellDisassemblyRecipeBuilder namespace(String namespace) {
        this.overrideNamespace = namespace;
        return this;
    }

    public CellDisassemblyRecipeBuilder folder(String folder) {
        this.folder = folder == null ? "" : folder;
        return this;
    }

    public void save(RecipeOutput out) {
        this.save(out, this.defaultId());
    }

    public void save(RecipeOutput out, String path) {
        ResourceLocation base = BuiltInRegistries.ITEM.getKey((Object)this.cell.asItem());
        String ns = this.overrideNamespace != null ? this.overrideNamespace : base.getNamespace();
        String fullPath = this.folder == null || this.folder.isEmpty() ? path : this.folder + "/" + path;
        this.save(out, ResourceLocation.fromNamespaceAndPath((String)ns, (String)fullPath));
    }

    public void save(RecipeOutput out, ResourceLocation id) {
        if (this.outputs.isEmpty()) {
            throw new IllegalStateException("cell_disassembly recipe must have at least one output");
        }
        StorageCellDisassemblyRecipe recipe = new StorageCellDisassemblyRecipe(this.cell.asItem(), List.copyOf(this.outputs));
        if (this.conditions.isEmpty()) {
            out.accept(id, (Recipe)recipe, null);
        } else {
            out.withConditions((ICondition[])this.conditions.toArray(ICondition[]::new)).accept(id, (Recipe)recipe, null);
        }
    }

    private ResourceLocation defaultId() {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)this.cell.asItem());
        String ns = this.overrideNamespace != null ? this.overrideNamespace : itemId.getNamespace();
        String path = itemId.getPath() + "_disassembly";
        if (this.folder != null && !this.folder.isEmpty()) {
            path = this.folder + "/" + path;
        }
        return ResourceLocation.fromNamespaceAndPath((String)ns, (String)path);
    }
}

