/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.daynightvote;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DayNightVote
extends JavaPlugin
implements CommandExecutor {
    private boolean voteActive = false;
    private long voteEndTime = 0L;
    private final Map<UUID, String> votes = new HashMap<UUID, String>();
    private BossBar voteBar;
    private int nightVotes = 0;
    private int dayVotes = 0;
    private int taskId = -1;
    private int voteDurationSeconds;
    private String voteStartMessage;
    private String voteEndMessageDay;
    private String voteEndMessageNight;
    private String voteEndMessageTie;
    private String alreadyVotedMessage;
    private String noActiveVoteMessage;
    private String voteSuccessMessage;
    private String noPermissionMessage;
    private String invalidArgumentMessage;
    private String bossBarTitle;
    private BarColor bossBarColor;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.getCommand("dnvote").setExecutor((CommandExecutor)this);
        this.voteBar = Bukkit.createBossBar((String)this.bossBarTitle, (BarColor)this.bossBarColor, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        this.getLogger().info("DayNightVote has been enabled!");
    }

    public void onDisable() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
        this.voteBar.setVisible(false);
        this.voteBar.removeAll();
        this.getLogger().info("DayNightVote has been disabled!");
    }

    private void loadConfiguration() {
        FileConfiguration config = this.getConfig();
        this.voteDurationSeconds = config.getInt("vote-duration-seconds", 60);
        this.voteStartMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.vote-start", "&a[DNV] &eVoting for time change has started! Use &b/dnvote day&e or &b/dnvote night&e to cast your vote!"));
        this.voteEndMessageDay = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.vote-end-day", "&a[DNV] &eVoting ended! Day won with &b%day%&e votes vs &b%night%&e votes. Setting time to day."));
        this.voteEndMessageNight = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.vote-end-night", "&a[DNV] &eVoting ended! Night won with &b%night%&e votes vs &b%day%&e votes. Setting time to night."));
        this.voteEndMessageTie = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.vote-end-tie", "&a[DNV] &eVoting ended in a tie! No change will be made."));
        this.alreadyVotedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.already-voted", "&a[DNV] &cYou have already voted! You voted for: &b%vote%"));
        this.noActiveVoteMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no-active-vote", "&a[DNV] &cThere is no active vote at the moment."));
        this.voteSuccessMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.vote-success", "&a[DNV] &eYou voted for &b%vote%&e! Current tally: &bDay: %day% | Night: %night%"));
        this.noPermissionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.no-permission", "&a[DNV] &cYou don't have permission to use this command."));
        this.invalidArgumentMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.invalid-argument", "&a[DNV] &cInvalid argument. Usage: /dnvote [day|night|start|check]"));
        this.bossBarTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("bossbar.title", "&e\u23f0 Time Vote in Progress &e\u23f0"));
        String barColorStr = config.getString("bossbar.color", "YELLOW");
        try {
            this.bossBarColor = BarColor.valueOf((String)barColorStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.bossBarColor = BarColor.YELLOW;
            this.getLogger().warning("Invalid boss bar color in config. Using default YELLOW.");
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String arg;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendUsage(player);
            return true;
        }
        switch (arg = args[0].toLowerCase()) {
            case "day": {
                if (!player.hasPermission("dnvote.vote")) {
                    player.sendMessage(this.noPermissionMessage);
                    return true;
                }
                this.voteForTime(player, "day");
                break;
            }
            case "night": {
                if (!player.hasPermission("dnvote.vote")) {
                    player.sendMessage(this.noPermissionMessage);
                    return true;
                }
                this.voteForTime(player, "night");
                break;
            }
            case "start": {
                if (!player.hasPermission("dnvote.start")) {
                    player.sendMessage(this.noPermissionMessage);
                    return true;
                }
                this.startVote();
                break;
            }
            case "check": {
                if (!player.hasPermission("dnvote.check")) {
                    player.sendMessage(this.noPermissionMessage);
                    return true;
                }
                this.checkVoteStatus(player);
                break;
            }
            default: {
                player.sendMessage(this.invalidArgumentMessage);
            }
        }
        return true;
    }

    private void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "===== DayNightVote Help =====");
        if (player.hasPermission("dnvote.vote")) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "/dnvote day" + String.valueOf(ChatColor.WHITE) + " - Vote for day time");
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "/dnvote night" + String.valueOf(ChatColor.WHITE) + " - Vote for night time");
        }
        if (player.hasPermission("dnvote.check")) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "/dnvote check" + String.valueOf(ChatColor.WHITE) + " - Check current vote status");
        }
        if (player.hasPermission("dnvote.start")) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "/dnvote start" + String.valueOf(ChatColor.WHITE) + " - Start a new vote");
        }
    }

    private void startVote() {
        if (this.voteActive) {
            return;
        }
        this.voteActive = true;
        this.votes.clear();
        this.dayVotes = 0;
        this.nightVotes = 0;
        this.voteEndTime = System.currentTimeMillis() + (long)this.voteDurationSeconds * 1000L;
        this.voteBar.setProgress(1.0);
        this.voteBar.setVisible(true);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.voteBar.addPlayer(player);
        }
        Bukkit.broadcastMessage((String)this.voteStartMessage);
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            long timeLeft = this.voteEndTime - System.currentTimeMillis();
            if (timeLeft <= 0L) {
                this.endVote();
                return;
            }
            double progress = (double)timeLeft / (double)((long)this.voteDurationSeconds * 1000L);
            this.voteBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
        }, 0L, 20L);
    }

    private void voteForTime(Player player, String choice) {
        UUID playerUUID;
        if (!this.voteActive) {
            this.startVote();
        }
        if (this.votes.containsKey(playerUUID = player.getUniqueId())) {
            String previousVote = this.votes.get(playerUUID);
            player.sendMessage(this.alreadyVotedMessage.replace("%vote%", previousVote));
            return;
        }
        this.votes.put(playerUUID, choice);
        this.updateVoteCounts();
        player.sendMessage(this.voteSuccessMessage.replace("%vote%", choice).replace("%day%", String.valueOf(this.dayVotes)).replace("%night%", String.valueOf(this.nightVotes)));
    }

    private void updateVoteCounts() {
        this.dayVotes = 0;
        this.nightVotes = 0;
        for (String vote : this.votes.values()) {
            if (vote.equals("day")) {
                ++this.dayVotes;
                continue;
            }
            if (!vote.equals("night")) continue;
            ++this.nightVotes;
        }
    }

    private void checkVoteStatus(Player player) {
        if (!this.voteActive) {
            player.sendMessage(this.noActiveVoteMessage);
            return;
        }
        long timeLeft = (this.voteEndTime - System.currentTimeMillis()) / 1000L;
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Current vote status:");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Day votes: " + String.valueOf(ChatColor.AQUA) + this.dayVotes);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Night votes: " + String.valueOf(ChatColor.AQUA) + this.nightVotes);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Time remaining: " + String.valueOf(ChatColor.AQUA) + timeLeft + " seconds");
    }

    private void endVote() {
        if (!this.voteActive) {
            return;
        }
        this.voteActive = false;
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
            this.taskId = -1;
        }
        this.voteBar.setVisible(false);
        this.voteBar.removeAll();
        if (this.dayVotes > this.nightVotes) {
            for (World world : Bukkit.getWorlds()) {
                world.setTime(1000L);
            }
            Bukkit.broadcastMessage((String)this.voteEndMessageDay.replace("%day%", String.valueOf(this.dayVotes)).replace("%night%", String.valueOf(this.nightVotes)));
        } else if (this.nightVotes > this.dayVotes) {
            for (World world : Bukkit.getWorlds()) {
                world.setTime(13000L);
            }
            Bukkit.broadcastMessage((String)this.voteEndMessageNight.replace("%day%", String.valueOf(this.dayVotes)).replace("%night%", String.valueOf(this.nightVotes)));
        } else {
            Bukkit.broadcastMessage((String)this.voteEndMessageTie.replace("%day%", String.valueOf(this.dayVotes)).replace("%night%", String.valueOf(this.nightVotes)));
        }
        this.votes.clear();
        this.dayVotes = 0;
        this.nightVotes = 0;
    }
}

