/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.GravestoneMod;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GraveUtils {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);

    @Nullable
    public static BlockPos getGraveStoneLocation(Level world, BlockPos pos) {
        BlockPos.MutableBlockPos location = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
        location.set((Vec3i)world.getWorldBorder().clampToBounds((BlockPos)location));
        if (world.isOutsideBuildHeight((BlockPos)location) && location.getY() <= world.getMinY()) {
            location.set(location.getX(), world.getMinY() + 1, location.getZ());
        }
        while (!world.isOutsideBuildHeight((BlockPos)location)) {
            if (GraveUtils.isReplaceable(world, (BlockPos)location)) {
                return location;
            }
            location.move(0, 1, 0);
        }
        if (((Boolean)GravestoneMod.SERVER_CONFIG.strictPlacement.get()).booleanValue()) {
            location.set(location.getX(), world.getMaxY(), location.getZ());
            return location;
        }
        return null;
    }

    public static boolean isReplaceable(Level world, BlockPos pos) {
        Block b = world.getBlockState(pos).getBlock();
        if (world.isEmptyBlock(pos)) {
            return true;
        }
        return GravestoneMod.SERVER_CONFIG.replaceableBlocks.stream().anyMatch(blockTag -> blockTag.contains(b));
    }

    @Nullable
    public static MutableComponent getDate(long timestamp) {
        if (timestamp <= 0L) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(Component.translatable((String)"gui.gravestone.date_format").getString());
        return Component.literal((String)dateFormat.format(new Date(timestamp)));
    }

    public static boolean canBreakGrave(Level world, Player player, BlockPos pos) {
        ServerPlayer p;
        if (player.isDeadOrDying()) {
            return false;
        }
        if (!((Boolean)GravestoneMod.SERVER_CONFIG.onlyOwnersCanBreak.get()).booleanValue()) {
            return true;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (!(te instanceof GraveStoneTileEntity)) {
            return true;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)te;
        if (player instanceof ServerPlayer && (p = (ServerPlayer)player).hasPermissions(p.getServer().getOperatorUserPermissionLevel())) {
            return true;
        }
        UUID uuid = grave.getDeath().getPlayerUUID();
        if (uuid.equals(EMPTY_UUID)) {
            return true;
        }
        return player.getUUID().equals(uuid);
    }
}

