/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.gravestone.corelib.client.PlayerSkins;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5EarsLayer;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;

public class PlayerGhostRenderer
extends LivingEntityRenderer<GhostPlayerEntity, PlayerRenderState, PlayerModel> {
    private final PlayerModel playerModel;
    private final PlayerModel playerModelSlim;

    public PlayerGhostRenderer(EntityRendererProvider.Context context) {
        super(context, null, 0.5f);
        this.playerModel = new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false);
        this.playerModelSlim = new PlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        this.model = this.playerModel;
        this.addLayer((RenderLayer)new PlayerItemInHandLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new ArrowLayer((LivingEntityRenderer)this, context));
        this.addLayer((RenderLayer)new Deadmau5EarsLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new CapeLayer((RenderLayerParent)this, context.getModelSet(), context.getEquipmentAssets()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), CustomHeadLayer.Transforms.DEFAULT));
        this.addLayer((RenderLayer)new WingsLayer((RenderLayerParent)this, context.getModelSet(), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new ParrotOnShoulderLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this, context));
    }

    public void render(PlayerRenderState state, PoseStack stack, MultiBufferSource source, int light) {
        this.model = state.skin.model().equals((Object)PlayerSkin.Model.SLIM) ? this.playerModelSlim : this.playerModel;
        super.render((LivingEntityRenderState)state, stack, source, light);
    }

    protected boolean shouldShowName(GhostPlayerEntity entity, double d) {
        return false;
    }

    public PlayerRenderState createRenderState() {
        return new PlayerRenderState();
    }

    public void extractRenderState(GhostPlayerEntity entity, PlayerRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)entity, (HumanoidRenderState)state, (float)partialTicks, (ItemModelResolver)this.itemModelResolver);
        state.skin = PlayerSkins.getSkin(entity.getPlayerUUID());
        state.showHat = entity.isWearing(PlayerModelPart.HAT);
        state.showJacket = entity.isWearing(PlayerModelPart.JACKET);
        state.showLeftPants = entity.isWearing(PlayerModelPart.LEFT_PANTS_LEG);
        state.showRightPants = entity.isWearing(PlayerModelPart.RIGHT_PANTS_LEG);
        state.showLeftSleeve = entity.isWearing(PlayerModelPart.LEFT_SLEEVE);
        state.showRightSleeve = entity.isWearing(PlayerModelPart.RIGHT_SLEEVE);
        state.showCape = entity.isWearing(PlayerModelPart.CAPE);
        state.id = entity.getId();
        state.name = entity.getName().getString();
    }

    protected void scale(PlayerRenderState state, PoseStack stack) {
        float scale = 0.9375f;
        stack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(PlayerRenderState state) {
        return state.skin.texture();
    }
}

