/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.maxhenkel.gravestone.GravestoneMod;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.corelib.death.DeathManager;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RestoreCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)Commands.literal((String)"restore").requires(commandSource -> commandSource.hasPermission(2));
        Command add = commandSource -> {
            UUID deathID = UuidArgument.getUuid((CommandContext)commandSource, (String)"death_id");
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)commandSource, (String)"target");
            Death death = DeathManager.getDeath(player.level(), deathID);
            if (death == null) {
                ((CommandSourceStack)commandSource.getSource()).sendFailure((Component)Component.translatable((String)"message.gravestone.death_id_not_found", (Object[])new Object[]{deathID.toString()}));
                return 0;
            }
            for (ItemStack stack : death.getAllItems()) {
                if (player.getInventory().add(stack)) continue;
                player.drop(stack, false);
            }
            ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.gravestone.restore.success", (Object[])new Object[]{player.getDisplayName()}), true);
            return 1;
        };
        Command replace = commandSource -> {
            UUID deathID = UuidArgument.getUuid((CommandContext)commandSource, (String)"death_id");
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)commandSource, (String)"target");
            Death death = DeathManager.getDeath(player.level(), deathID);
            if (death == null) {
                ((CommandSourceStack)commandSource.getSource()).sendFailure((Component)Component.translatable((String)"message.gravestone.death_id_not_found", (Object[])new Object[]{deathID.toString()}));
                return 0;
            }
            player.getInventory().clearContent();
            NonNullList<ItemStack> itemStacks = ((GraveStoneBlock)((Object)((Object)GravestoneMod.GRAVESTONE.get()))).fillPlayerInventory((Player)player, death);
            for (ItemStack stack : itemStacks) {
                player.drop(stack, false);
            }
            ((CommandSourceStack)commandSource.getSource()).sendSuccess(() -> Component.translatable((String)"message.gravestone.restore.success", (Object[])new Object[]{player.getDisplayName()}), true);
            return 1;
        };
        literalBuilder.then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"death_id", (ArgumentType)UuidArgument.uuid()).then(Commands.literal((String)"replace").executes(replace))).then(Commands.literal((String)"add").executes(add))));
        LiteralCommandNode register = dispatcher.register(literalBuilder);
        LiteralArgumentBuilder alias = (LiteralArgumentBuilder)Commands.literal((String)"restoreinventory").redirect((CommandNode)register);
        dispatcher.register(alias);
    }
}

