/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.corelib.dataserializers;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class DataSerializerEquipment {
    private static final StreamCodec<RegistryFriendlyByteBuf, EnumMap<EquipmentSlot, ItemStack>> CODEC = new StreamCodec<RegistryFriendlyByteBuf, EnumMap<EquipmentSlot, ItemStack>>(){

        public void encode(RegistryFriendlyByteBuf buf, EnumMap<EquipmentSlot, ItemStack> equipment) {
            List<Map.Entry> list = equipment.entrySet().stream().filter(e -> !((ItemStack)e.getValue()).isEmpty()).toList();
            buf.writeInt(list.size());
            for (Map.Entry entry : list) {
                buf.writeUtf(((EquipmentSlot)entry.getKey()).getName());
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)((ItemStack)entry.getValue()));
            }
        }

        public EnumMap<EquipmentSlot, ItemStack> decode(RegistryFriendlyByteBuf buf) {
            int length = buf.readInt();
            EnumMap<EquipmentSlot, ItemStack> map = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
            for (int i = 0; i < length; ++i) {
                String name = buf.readUtf();
                EquipmentSlot slot = EquipmentSlot.byName((String)name);
                map.put(slot, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
            }
            return map;
        }
    };

    public static EntityDataSerializer<EnumMap<EquipmentSlot, ItemStack>> create() {
        return new EntityDataSerializer<EnumMap<EquipmentSlot, ItemStack>>(){

            public StreamCodec<? super RegistryFriendlyByteBuf, EnumMap<EquipmentSlot, ItemStack>> codec() {
                return CODEC;
            }

            public EnumMap<EquipmentSlot, ItemStack> copy(EnumMap<EquipmentSlot, ItemStack> equipment) {
                EnumMap<EquipmentSlot, ItemStack> copy = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
                for (Map.Entry<EquipmentSlot, ItemStack> entry : equipment.entrySet()) {
                    copy.put(entry.getKey(), entry.getValue().copy());
                }
                return copy;
            }
        };
    }
}

