/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.integration.waila;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerGraveStone
implements IBlockComponentProvider {
    public static final HUDHandlerGraveStone INSTANCE = new HUDHandlerGraveStone();
    private static final ResourceLocation OBJECT_NAME_TAG = ResourceLocation.fromNamespaceAndPath((String)"jade", (String)"object_name");
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"gravestone", (String)"grave");

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof GraveStoneTileEntity) {
            CompoundTag data;
            GraveStoneTileEntity grave = (GraveStoneTileEntity)blockEntity;
            iTooltip.remove(OBJECT_NAME_TAG);
            iTooltip.add((Component)grave.getName().copy().withStyle(ChatFormatting.WHITE));
            MutableComponent time = GraveUtils.getDate(grave.getDeath().getTimestamp());
            if (time != null) {
                iTooltip.add((Component)Component.translatable((String)"message.gravestone.date_of_death", (Object[])new Object[]{time}));
            }
            if ((data = blockAccessor.getServerData()).contains("ItemCount")) {
                iTooltip.add((Component)Component.translatable((String)"message.gravestone.item_count", (Object[])new Object[]{data.getIntOr("ItemCount", 0)}));
            }
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

