/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.agent;

import com.abdik.shiro.ModConfig;
import com.abdik.shiro.agent.ClassFinalModifierBreakerTransformer;
import com.abdik.shiro.agent.DirectBufferCleanerTransformer;
import com.abdik.shiro.agent.FileAccessBlockerTransformer;
import com.abdik.shiro.agent.ReferenceCleanerTransformer;
import com.abdik.shiro.agent.ThreadLocalCleanerTransformer;
import com.abdik.shiro.util.JVMWatchdog;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;

public final class AgentBootstrap {
    public static volatile Instrumentation INSTRUMENTATION;
    private static Thread watchdogThread;

    public static void premain(String agentArgs, Instrumentation inst) {
        AgentBootstrap.init(inst);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        AgentBootstrap.init(inst);
    }

    private static void init(Instrumentation inst) {
        INSTRUMENTATION = inst;
        inst.addTransformer(new NoopTransformer(), true);
        inst.addTransformer(new ThreadLocalCleanerTransformer(), true);
        inst.addTransformer(new DirectBufferCleanerTransformer(), true);
        inst.addTransformer(new ReferenceCleanerTransformer(), true);
        inst.addTransformer(new ClassFinalModifierBreakerTransformer(), true);
        inst.addTransformer(new FileAccessBlockerTransformer(), true);
        AgentBootstrap.startWatchdog();
    }

    private static void startWatchdog() {
        if (watchdogThread != null) {
            return;
        }
        ModConfig config = ModConfig.load();
        JVMWatchdog watchdog = new JVMWatchdog(config);
        watchdogThread = new Thread((Runnable)watchdog, "Shiro-Agent-Watchdog");
        watchdogThread.setDaemon(true);
        watchdogThread.start();
    }

    private static class NoopTransformer
    implements ClassFileTransformer {
        private NoopTransformer() {
        }

        @Override
        public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            return null;
        }
    }
}

