/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.agent;

import com.abdik.shiro.ModConfig;
import com.abdik.shiro.policy.CustomPolicy;
import com.abdik.shiro.security.SecurityPolicy;
import java.lang.instrument.ClassFileTransformer;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;

public class FileAccessBlockerTransformer
implements ClassFileTransformer {
    private static boolean active = false;

    @Override
    public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classfileBuffer) {
        return null;
    }

    private static void enableSecurityManager() {
        if (active) {
            return;
        }
        active = true;
        Policy.setPolicy(new CustomPolicy());
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkRead(String file) {
                if (!SecurityPolicy.isAllowedPath(file)) {
                    throw new SecurityException("Blocked unauthorized file read: " + file);
                }
            }

            @Override
            public void checkWrite(String file) {
                if (!SecurityPolicy.isAllowedPath(file)) {
                    throw new SecurityException("Blocked unauthorized file write: " + file);
                }
            }

            @Override
            public void checkDelete(String file) {
                if (!SecurityPolicy.isAllowedPath(file)) {
                    throw new SecurityException("Blocked unauthorized file delete: " + file);
                }
            }

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        System.out.println("[Shiro] File access sandbox enabled.");
    }

    static {
        try {
            ModConfig config = ModConfig.load();
            if (config.enableSecuritySandbox) {
                FileAccessBlockerTransformer.enableSecurityManager();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

