/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.agent;

import com.abdik.shiro.agent.AgentBootstrap;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;

public class ReferenceCleanerTransformer
implements ClassFileTransformer {
    private static volatile boolean started = false;
    private static final long SCAN_INTERVAL_MS = 90000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classfileBuffer) {
        if (started || className == null || !className.equals("java/lang/ref/SoftReference") && !className.equals("java/lang/ref/WeakReference") && !className.equals("java/lang/ref/Finalizer")) return null;
        Class<ReferenceCleanerTransformer> clazz = ReferenceCleanerTransformer.class;
        synchronized (ReferenceCleanerTransformer.class) {
            if (started) return null;
            started = true;
            ReferenceCleanerTransformer.startCleanerThread();
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return null;
        }
    }

    private static void startCleanerThread() {
        Thread t = new Thread(() -> {
            while (true) {
                try {
                    Instrumentation inst = AgentBootstrap.INSTRUMENTATION;
                    if (inst != null) {
                        Class[] loaded;
                        for (Class cls : loaded = inst.getAllLoadedClasses()) {
                            try {
                                Field[] fields;
                                String cn = cls.getName();
                                if (cn == null || !cn.startsWith("com.abdik.shiro")) continue;
                                for (Field f : fields = cls.getDeclaredFields()) {
                                    try {
                                        Class<?> ft = f.getType();
                                        if (!Reference.class.isAssignableFrom(ft) && !SoftReference.class.isAssignableFrom(ft) && !WeakReference.class.isAssignableFrom(ft)) continue;
                                        f.setAccessible(true);
                                        Object val = f.get(null);
                                        if (!(val instanceof Reference)) continue;
                                        Reference ref = (Reference)val;
                                        try {
                                            if (ref.get() != null) continue;
                                            f.set(null, null);
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        // empty catch block
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (System.currentTimeMillis() % 630000L < 90000L) {
                        try {
                            System.gc();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable inst) {
                    // empty catch block
                }
                try {
                    Thread.sleep(90000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }, "Shiro-Reference-Cleaner");
        t.setDaemon(true);
        t.start();
    }
}

