/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import com.abdik.shiro.cpu.WorkerThreadManager;

public class AdaptiveThreadPoolManager {
    private final WorkerThreadManager workerThreadManager;

    public AdaptiveThreadPoolManager(int initialThreads, int maxThreads) {
        this.workerThreadManager = new WorkerThreadManager(initialThreads, maxThreads);
    }

    public void adjustThreadPool(double cpuLoad) {
        int newThreadCount = (int)(cpuLoad * 10.0);
        int maxThreads = this.workerThreadManager.getMaxThreads();
        int adjustedCount = Math.max(1, Math.min(newThreadCount, maxThreads));
        this.workerThreadManager.adjustThreadPool(adjustedCount);
        System.out.println("[AdaptiveThreadPoolManager] Adjusted thread pool size to: " + adjustedCount);
    }
}

