/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import java.util.concurrent.RecursiveTask;

public class ForkJoinTaskExample {
    public static int computeSum(int start, int end) {
        ComputeTask task = new ComputeTask(start, end);
        return (Integer)task.fork().join();
    }

    public static class ComputeTask
    extends RecursiveTask<Integer> {
        private static final long serialVersionUID = 1L;
        private final int start;
        private final int end;

        public ComputeTask(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        protected Integer compute() {
            if (this.end - this.start <= 1) {
                return this.start;
            }
            int mid = (this.start + this.end) / 2;
            ComputeTask task1 = new ComputeTask(this.start, mid);
            ComputeTask task2 = new ComputeTask(mid, this.end);
            task1.fork();
            task2.fork();
            return (Integer)task1.join() + (Integer)task2.join();
        }
    }
}

