/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JITPreWarmer {
    public static void warmUp() {
        System.out.println("[JITPreWarmer] Starting JIT pre-warm...");
        try {
            String[] heavyMethods;
            Class<?> clazz = Class.forName("com.abdik.shiro.ShiroMod");
            for (String methodName : heavyMethods = new String[]{"minimumCleanup", "mediumCleanup", "hardCleanup"}) {
                try {
                    Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
                    if (!Modifier.isStatic(method.getModifiers()) || method.getParameterCount() != 0) continue;
                    method.setAccessible(true);
                    method.invoke(null, new Object[0]);
                    System.out.println("[JITPreWarmer] Invoked heavy method: " + methodName);
                }
                catch (Throwable t) {
                    System.err.println("[JITPreWarmer] Failed to invoke method " + methodName + ": " + String.valueOf(t));
                }
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("[JITPreWarmer] Class not found: " + e.getMessage());
        }
        System.out.println("[JITPreWarmer] JIT pre-warm completed.");
    }
}

