/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.cpu;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WorkerThreadManager {
    private final ThreadPoolExecutor executor;
    private final int maxThreads;
    private final int minThreads;

    public WorkerThreadManager(int minThreads, int maxThreads) {
        this.minThreads = minThreads;
        this.maxThreads = maxThreads;
        this.executor = new ThreadPoolExecutor(minThreads, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void adjustThreadPool(double cpuLoad) {
        int targetThreads = cpuLoad < 0.3 ? this.maxThreads : (cpuLoad < 0.7 ? (this.maxThreads + this.minThreads) / 2 : this.minThreads);
        this.executor.setCorePoolSize(targetThreads);
        this.executor.setMaximumPoolSize(targetThreads);
    }

    public void submit(Runnable task) {
        this.executor.submit(task);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }
}

