/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.gpu;

import com.abdik.shiro.gpu.GPUInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public final class GPUCapDetector {
    private GPUCapDetector() {
    }

    public static boolean isGPUBottlenecked() {
        int gpuUtil = GPUInfo.getUtilization();
        int cpuLoad = GPUCapDetector.getCpuLoadPercent();
        return gpuUtil >= 80 && cpuLoad >= 0 && cpuLoad < 50;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getCpuLoadPercent() {
        try {
            String[] cmd = new String[]{"bash", "-lc", "top -bn2 | grep 'Cpu(s)' | tail -n1"};
            Process p = Runtime.getRuntime().exec(cmd);
            try (BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String[] parts;
                String line = r.readLine();
                if (line == null) {
                    int n = -1;
                    return n;
                }
                String[] stringArray = parts = line.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (part.contains("id")) {
                        String idleStr = part.trim().split(" ")[0];
                        idleStr = idleStr.replace("%", "").trim();
                        float idle = Float.parseFloat(idleStr);
                        int n3 = (int)(100.0f - idle);
                        return n3;
                    }
                    ++n2;
                }
                return -1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }
}

