/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.gpu;

import com.abdik.shiro.gpu.GPUInfo;
import com.abdik.shiro.gpu.GPUVendor;

public final class GPUClockTuner {
    private GPUClockTuner() {
    }

    public static void applyClockTuning() {
        GPUVendor vendor = GPUInfo.getVendor();
        try {
            switch (vendor) {
                case NVIDIA: {
                    GPUClockTuner.runCommand(new String[]{"nvidia-smi", "-pm", "1"});
                    break;
                }
                case AMD: {
                    GPUClockTuner.runCommand(new String[]{"rocm-smi", "--setperflevel", "auto"});
                    break;
                }
                case INTEL: {
                    GPUClockTuner.runCommand(new String[]{"bash", "-lc", "echo 'intel tuning not supported by default' > /dev/null"});
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[GPUClockTuner] Clock tuning failed: " + e.getMessage());
        }
    }

    private static void runCommand(String[] command) throws Exception {
        Process proc = Runtime.getRuntime().exec(command);
        int exitCode = proc.waitFor();
        if (exitCode != 0) {
            throw new RuntimeException("Command failed (exit " + exitCode + "): " + String.join((CharSequence)" ", command));
        }
    }
}

