/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.hooks;

import com.abdik.shiro.ShiroMod;
import com.abdik.shiro.runtime.MemoryCleaner;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_310;

public class WorldDisconnectWatcher
implements ClientModInitializer {
    private volatile boolean disconnected = false;
    private volatile boolean running = true;

    public void onInitializeClient() {
        if (!ShiroMod.config.cleanupOnWorldDisconnect) {
            return;
        }
        Thread watcher = new Thread(this::monitorDisconnect, "Shiro-WorldDisconnectWatcher");
        watcher.setDaemon(true);
        watcher.start();
    }

    private void monitorDisconnect() {
        class_310 client = class_310.method_1551();
        while (ShiroMod.running && this.running) {
            try {
                boolean nowDisconnected;
                Thread.sleep(1000L);
                boolean bl = nowDisconnected = client.method_1562() == null || client.field_1687 == null || client.field_1724 == null;
                if (nowDisconnected && !this.disconnected) {
                    this.disconnected = true;
                    System.out.println("[Shiro] Player disconnected \u2014 scheduling memory cleanup.");
                    client.execute(() -> {
                        try {
                            MemoryCleaner.cleanAll();
                            System.out.println("[Shiro] Memory cleanup complete.");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                    continue;
                }
                if (nowDisconnected || !this.disconnected) continue;
                this.disconnected = false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void stop() {
        this.running = false;
    }
}

