/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.io;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;

public class DiskIOPressureDetector {
    private static volatile boolean highIOPressure = false;

    public static void init() {
        Thread monitorThread = new Thread(() -> {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    double load = os.getSystemLoadAverage();
                    highIOPressure = load >= 5.0;
                    Thread.sleep(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, "DiskIOPressureMonitor");
        monitorThread.setDaemon(true);
        monitorThread.start();
    }

    public static boolean isUnderIOPressure() {
        return highIOPressure;
    }
}

