/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.io;

import com.abdik.shiro.io.AsyncIODispatcher;
import com.abdik.shiro.io.DiskIOPressureDetector;
import com.abdik.shiro.io.FileDescriptorPool;
import com.abdik.shiro.io.FileSystemWatcher;
import com.abdik.shiro.io.IOManager;
import com.abdik.shiro.io.IOPerfGovernor;
import com.abdik.shiro.io.IOThrottler;
import com.abdik.shiro.io.StorageDeviceDetector;
import com.abdik.shiro.natives.ShiroSafeNativeUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import net.fabricmc.api.ModInitializer;

public class IOMod
implements ModInitializer {
    private Thread fileWatcherThread;
    private static final int BUFFER_SIZE = 0x100000;
    private static final int ALIGNMENT = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitialize() {
        System.out.println("[ShiroIO] Initializing I/O Optimization Module...");
        DiskIOPressureDetector.init();
        StorageDeviceDetector.detect();
        IOPerfGovernor.init();
        IOThrottler.init(IOPerfGovernor.getMaxConcurrentIOThreads());
        IOManager.init();
        IOManager.prefetchCriticalMinecraftPaths();
        AsyncIODispatcher.init();
        long bufferAddr = ShiroSafeNativeUtils.allocAligned(0x100000L, 4096);
        if (bufferAddr != 0L) {
            ByteBuffer alignedBuffer = ByteBuffer.allocateDirect(0x100000).order(ByteOrder.nativeOrder());
            try {
                Path tempFile = Paths.get(System.getProperty("user.home"), ".minecraft", "logs", "latest.log");
                try (FileChannel fc = FileChannel.open(tempFile, StandardOpenOption.READ);){
                    int bytesRead = fc.read(alignedBuffer);
                    System.out.println("[ShiroIO] Prefetched " + bytesRead + " bytes into aligned buffer");
                }
            }
            catch (IOException e) {
                System.err.println("[ShiroIO] Failed to read into aligned buffer: " + e.getMessage());
            }
            finally {
                ShiroSafeNativeUtils.freeAligned(bufferAddr);
            }
        }
        try {
            Path poolPath = Paths.get(System.getProperty("user.home"), ".minecraft", "logs", "latest.log");
            FileDescriptorPool.init(poolPath);
        }
        catch (IOException e) {
            System.err.println("[ShiroIO] Failed to initialize FileDescriptorPool: " + e.getMessage());
        }
        try {
            Path watchPath = Paths.get(System.getProperty("user.home"), ".minecraft", "config");
            FileSystemWatcher watcher = new FileSystemWatcher(watchPath);
            this.fileWatcherThread = new Thread((Runnable)watcher, "ShiroIO-FileWatcher");
            this.fileWatcherThread.setDaemon(true);
            this.fileWatcherThread.start();
        }
        catch (IOException e) {
            System.err.println("[ShiroIO] Failed to start FileSystemWatcher: " + e.getMessage());
        }
        System.out.println("[ShiroIO] I/O Optimization Module initialized.");
    }
}

