/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.io;

import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;

public class StorageDeviceDetector {
    private static volatile boolean ssdDetected = false;

    public static void detect() {
        try {
            FileSystem fs = FileSystems.getDefault();
            Iterator<Path> roots = fs.getRootDirectories().iterator();
            if (roots.hasNext()) {
                Path root = roots.next();
                FileStore store = Files.getFileStore(root);
                String type = store.type().toLowerCase();
                ssdDetected = type.contains("ntfs") || type.contains("apfs") || type.contains("ext4") || type.contains("f2fs");
            }
        }
        catch (Exception e) {
            ssdDetected = false;
        }
    }

    public static boolean isSSD() {
        return ssdDetected;
    }
}

