/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.mixin;

import com.abdik.shiro.security.ShiroSecurity;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DatagramSocket.class}, remap=false)
public class MixinDatagramSocket {
    @Inject(method={"connect(Ljava/net/SocketAddress;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onConnect(SocketAddress endpoint, CallbackInfo ci) {
        try {
            InetSocketAddress inet;
            if (endpoint instanceof InetSocketAddress && !ShiroSecurity.isAllowedSocket(inet = (InetSocketAddress)endpoint)) {
                ci.cancel();
                System.err.println("[Shiro] Blocked DatagramSocket.connect() to: " + String.valueOf(inet));
                throw new SecurityException("DatagramSocket connection blocked by ShiroSecurity policy.");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Inject(method={"bind(Ljava/net/SocketAddress;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBind(SocketAddress endpoint, CallbackInfo ci) {
        try {
            InetSocketAddress inet;
            if (endpoint instanceof InetSocketAddress && !ShiroSecurity.isAllowedSocket(inet = (InetSocketAddress)endpoint)) {
                ci.cancel();
                System.err.println("[Shiro] Blocked DatagramSocket.bind() on: " + String.valueOf(inet));
                throw new SecurityException("DatagramSocket bind blocked by ShiroSecurity policy.");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

