/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.mixin;

import com.abdik.shiro.security.ShiroSecurity;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerSocket.class}, remap=false)
public class MixinServerSocket {
    @Inject(method={"bind(Ljava/net/SocketAddress;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBind(SocketAddress endpoint, int backlog, CallbackInfo ci) {
        try {
            InetSocketAddress inet;
            if (endpoint instanceof InetSocketAddress && !ShiroSecurity.isAllowedSocket(inet = (InetSocketAddress)endpoint)) {
                ci.cancel();
                System.err.println("[Shiro] Blocked ServerSocket.bind() on: " + String.valueOf(inet));
                throw new SecurityException("Binding blocked by ShiroSecurity policy.");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

