/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.natives;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class NativeLoader {
    public static void load() {
        String libPath;
        String arch;
        String os = System.getProperty("os.name").toLowerCase();
        String string = arch = System.getProperty("os.arch").contains("64") ? "x64" : "x86";
        if (os.contains("win")) {
            libPath = "natives/windows-" + arch + "/shironative.dll";
        } else if (os.contains("mac")) {
            libPath = "natives/macos-" + arch + "/libshironative.dylib";
        } else if (os.contains("nux") || os.contains("nix")) {
            libPath = "natives/linux-" + arch + "/libshironative.so";
        } else {
            throw new UnsupportedOperationException("Unsupported OS: " + os);
        }
        try (InputStream in = NativeLoader.class.getClassLoader().getResourceAsStream(libPath);){
            if (in == null) {
                throw new IOException("Missing native library: " + libPath);
            }
            Path tempFile = Files.createTempFile("shironative-", libPath.substring(libPath.lastIndexOf(46)), new FileAttribute[0]);
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
            tempFile.toFile().deleteOnExit();
            System.load(tempFile.toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load native library: " + libPath, e);
        }
    }
}

