/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.network;

import com.abdik.shiro.network.NetworkStatsMonitor;
import com.abdik.shiro.network.SilentSocketPool;

public class SocketLimitGovernor {
    private static final int SOCKET_LIMIT = 512;
    private static final long CHECK_INTERVAL_MS = 5000L;
    private static volatile boolean running = false;

    public static void init() {
        if (running) {
            return;
        }
        running = true;
        Thread governor = new Thread(() -> {
            System.out.println("[Shiro] SocketLimitGovernor active.");
            while (running) {
                try {
                    int open = NetworkStatsMonitor.getOpenSocketCount();
                    if (open > 512) {
                        System.err.println("[Shiro] \u26a0 Too many open sockets: " + open + " (limit 512)");
                        SilentSocketPool.clear();
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Throwable t) {
                    System.err.println("[Shiro] SocketLimitGovernor error: " + t.getMessage());
                }
            }
        }, "Shiro-SocketGovernor");
        governor.setDaemon(true);
        governor.start();
    }

    public static void stop() {
        running = false;
    }
}

