/*
 * Decompiled with CFR 0.152.
 */
package com.abdik.shiro.network;

import com.abdik.shiro.network.NetworkStatsMonitor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class WrappedSocket
extends Socket {
    private boolean tracked = false;

    public WrappedSocket() throws IOException {
        this.trackOpen();
    }

    public WrappedSocket(String host, int port) throws IOException {
        super(host, port);
        this.trackOpen();
    }

    public WrappedSocket(InetAddress address, int port) throws IOException {
        super(address, port);
        this.trackOpen();
    }

    public WrappedSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        super(host, port, localAddr, localPort);
        this.trackOpen();
    }

    public WrappedSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        super(address, port, localAddr, localPort);
        this.trackOpen();
    }

    private void trackOpen() {
        if (!this.tracked) {
            NetworkStatsMonitor.socketOpened(this);
            this.tracked = true;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.tracked) {
            NetworkStatsMonitor.socketClosed(this);
            this.tracked = false;
        }
        super.close();
    }
}

